/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.spanner;

import com.google.cloud.spanner.DatabaseClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTransactionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnClass(value={SpannerTransactionManager.class})
@AutoConfigureBefore(value={TransactionAutoConfiguration.class})
public class SpannerTransactionManagerAutoConfiguration {

    @Configuration
    @ConditionalOnSingleCandidate(value=DatabaseClient.class)
    static class DatabaseClientTransactionManagerConfiguration {
        private final DatabaseClient databaseClient;
        private final TransactionManagerCustomizers transactionManagerCustomizers;

        DatabaseClientTransactionManagerConfiguration(DatabaseClient databaseClient, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            this.databaseClient = databaseClient;
            this.transactionManagerCustomizers = (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable();
        }

        @Bean
        @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
        public SpannerTransactionManager spannerTransactionManager() {
            SpannerTransactionManager transactionManager = new SpannerTransactionManager(this.databaseClient);
            if (this.transactionManagerCustomizers != null) {
                this.transactionManagerCustomizers.customize((PlatformTransactionManager)transactionManager);
            }
            return transactionManager;
        }
    }
}

