/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.MountConfigMapPropertySource;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.log.LogAccessor;

public final class ConfigReloadUtil {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ConfigReloadUtil.class));

    private ConfigReloadUtil() {
    }

    public static boolean reload(String target, String sourceAsString, PropertySourceLocator locator, ConfigurableEnvironment environment, Class<? extends MapPropertySource> existingSourcesType) {
        LOG.debug(() -> "onEvent " + target + ": " + sourceAsString);
        return ConfigReloadUtil.reload(locator, environment, existingSourcesType);
    }

    public static boolean reload(PropertySourceLocator locator, ConfigurableEnvironment environment, Class<? extends MapPropertySource> existingSourcesType) {
        List<? extends MapPropertySource> existingSources = ConfigReloadUtil.findPropertySources(existingSourcesType, environment);
        if (existingSources.isEmpty()) {
            LOG.debug(() -> "no existingSources found, reload will not happen");
            return false;
        }
        List<MapPropertySource> sourceFromK8s = ConfigReloadUtil.locateMapPropertySources(locator, environment);
        boolean changed = ConfigReloadUtil.changed(sourceFromK8s, existingSources);
        if (changed) {
            LOG.info((CharSequence)"Detected change in config maps/secrets, reload will be triggered");
            return true;
        }
        LOG.debug((CharSequence)"Reloadable condition was not satisfied, reload will not be triggered");
        return false;
    }

    @Deprecated(forRemoval=false)
    public static <S extends PropertySource<?>> List<S> findPropertySources(Class<S> sourceClass, ConfigurableEnvironment environment) {
        ArrayList<Object> managedSources = new ArrayList<Object>();
        List sources = environment.getPropertySources().stream().collect(Collectors.toCollection(ArrayList::new));
        LOG.debug(() -> "environment from findPropertySources: " + environment);
        LOG.debug(() -> "environment sources from findPropertySources : " + sources);
        while (!sources.isEmpty()) {
            PropertySource source = (PropertySource)sources.remove(0);
            if (source instanceof CompositePropertySource) {
                CompositePropertySource comp = (CompositePropertySource)source;
                sources.addAll(comp.getPropertySources());
                continue;
            }
            if (sourceClass.isInstance(source)) {
                managedSources.add((PropertySource)sourceClass.cast(source));
                continue;
            }
            if (source instanceof MountConfigMapPropertySource) {
                MountConfigMapPropertySource mountConfigMapPropertySource = (MountConfigMapPropertySource)source;
                managedSources.add((Object)mountConfigMapPropertySource);
                continue;
            }
            if (!(source instanceof BootstrapPropertySource)) continue;
            BootstrapPropertySource bootstrapPropertySource = (BootstrapPropertySource)source;
            PropertySource propertySource = bootstrapPropertySource.getDelegate();
            LOG.debug(() -> "bootstrap delegate class : " + propertySource.getClass());
            if (sourceClass.isInstance(propertySource)) {
                sources.add(propertySource);
                continue;
            }
            if (!(propertySource instanceof MountConfigMapPropertySource)) continue;
            MountConfigMapPropertySource mountConfigMapPropertySource = (MountConfigMapPropertySource)propertySource;
            managedSources.add((Object)mountConfigMapPropertySource);
        }
        LOG.debug(() -> "findPropertySources : " + managedSources.stream().map(PropertySource::getName).toList());
        return managedSources;
    }

    static List<MapPropertySource> locateMapPropertySources(PropertySourceLocator propertySourceLocator, ConfigurableEnvironment environment) {
        ArrayList<MapPropertySource> result = new ArrayList<MapPropertySource>();
        PropertySource propertySource = propertySourceLocator.locate((Environment)environment);
        if (propertySource instanceof MapPropertySource) {
            MapPropertySource mapPropertySource = (MapPropertySource)propertySource;
            result.add(mapPropertySource);
        } else if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource source = (CompositePropertySource)propertySource;
            source.getPropertySources().forEach(x -> {
                if (x instanceof MapPropertySource) {
                    MapPropertySource mapPropertySource = (MapPropertySource)x;
                    result.add(mapPropertySource);
                }
            });
        } else {
            LOG.debug(() -> "Found property source that cannot be handled: " + propertySource.getClass());
        }
        LOG.debug(() -> "environment from locateMapPropertySources : " + environment);
        LOG.debug(() -> "sources from locateMapPropertySources : " + result);
        return result;
    }

    static boolean changed(List<? extends MapPropertySource> k8sSources, List<? extends MapPropertySource> appSources) {
        if (k8sSources.size() != appSources.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((CharSequence)("k8s property sources size: " + k8sSources.size()));
                k8sSources.forEach(item -> LOG.debug((CharSequence)item.toString()));
                LOG.debug((CharSequence)("app property sources size size: " + appSources.size()));
                appSources.forEach(item -> LOG.debug((CharSequence)item.toString()));
            }
            LOG.warn(() -> "The current number of PropertySources does not match the ones loaded from Kubernetes - No reload will take place");
            return false;
        }
        for (int i = 0; i < k8sSources.size(); ++i) {
            MapPropertySource appSource;
            MapPropertySource k8sSource = k8sSources.get(i);
            if (!ConfigReloadUtil.changed(k8sSource, appSource = appSources.get(i))) continue;
            LOG.debug(() -> "found change in : " + k8sSource);
            return true;
        }
        LOG.debug(() -> "no changes found, reload will not happen");
        return false;
    }

    static boolean changed(MapPropertySource k8sSource, MapPropertySource appSource) {
        Map appMap;
        if (k8sSource == appSource) {
            return false;
        }
        if (k8sSource == null || appSource == null) {
            return true;
        }
        Map k8sMap = (Map)k8sSource.getSource();
        return !Objects.equals(k8sMap, appMap = (Map)appSource.getSource());
    }
}

