/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.DiscoveryServerUrlInvalidException;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClientProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.discovery.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private RestTemplate rest;
    private KubernetesDiscoveryClientProperties properties;

    public KubernetesDiscoveryClient(RestTemplate rest, KubernetesDiscoveryClientProperties properties) {
        if (!StringUtils.hasText((String)properties.getDiscoveryServerUrl())) {
            throw new DiscoveryServerUrlInvalidException();
        }
        this.rest = rest;
        this.properties = properties;
    }

    public String description() {
        return "Kubernetes Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List<Object> response = Collections.emptyList();
        KubernetesServiceInstance[] responseBody = (KubernetesServiceInstance[])this.rest.getForEntity(this.properties.getDiscoveryServerUrl() + "/apps/" + serviceId, KubernetesServiceInstance[].class, new Object[0]).getBody();
        if (responseBody != null && responseBody.length > 0) {
            response = Arrays.stream(responseBody).filter(this::matchNamespaces).collect(Collectors.toList());
        }
        return response;
    }

    public List<String> getServices() {
        List<String> response = Collections.emptyList();
        Service[] services = (Service[])this.rest.getForEntity(this.properties.getDiscoveryServerUrl() + "/apps", Service[].class, new Object[0]).getBody();
        if (services != null && services.length > 0) {
            response = Arrays.stream(services).filter(this::matchNamespaces).map(Service::getName).collect(Collectors.toList());
        }
        return response;
    }

    private boolean matchNamespaces(KubernetesServiceInstance kubernetesServiceInstance) {
        if (CollectionUtils.isEmpty(this.properties.getNamespaces())) {
            return true;
        }
        return this.properties.getNamespaces().contains(kubernetesServiceInstance.getNamespace());
    }

    private boolean matchNamespaces(Service service) {
        if (CollectionUtils.isEmpty(service.getServiceInstances())) {
            return true;
        }
        return service.getServiceInstances().stream().anyMatch(this::matchNamespaces);
    }
}

