/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import java.util.EnumMap;
import java.util.Optional;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSourceType;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.cloud.kubernetes.commons.config.SourceDataEntriesProcessor;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigContext;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ContextToSourceData;
import org.springframework.cloud.kubernetes.fabric8.config.LabeledConfigMapContextToSourceDataProvider;
import org.springframework.cloud.kubernetes.fabric8.config.NamedConfigMapContextToSourceDataProvider;

public final class Fabric8ConfigMapPropertySource
extends SourceDataEntriesProcessor {
    private static final EnumMap<NormalizedSourceType, Fabric8ContextToSourceData> STRATEGIES = new EnumMap(NormalizedSourceType.class);

    Fabric8ConfigMapPropertySource(Fabric8ConfigContext context) {
        super(Fabric8ConfigMapPropertySource.getSourceData(context));
    }

    private static SourceData getSourceData(Fabric8ConfigContext context) {
        NormalizedSourceType type = context.normalizedSource().type();
        return Optional.ofNullable(STRATEGIES.get(type)).map(x -> (SourceData)x.apply(context)).orElseThrow(() -> new IllegalArgumentException("no strategy found for : " + type));
    }

    private static Fabric8ContextToSourceData namedConfigMap() {
        return new NamedConfigMapContextToSourceDataProvider().get();
    }

    private static Fabric8ContextToSourceData labeledConfigMap() {
        return new LabeledConfigMapContextToSourceDataProvider().get();
    }

    static {
        STRATEGIES.put(NormalizedSourceType.NAMED_CONFIG_MAP, Fabric8ConfigMapPropertySource.namedConfigMap());
        STRATEGIES.put(NormalizedSourceType.LABELED_CONFIG_MAP, Fabric8ConfigMapPropertySource.labeledConfigMap());
    }
}

