/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class EurekaHealthCheckHandler
implements HealthCheckHandler,
ApplicationContextAware,
InitializingBean {
    private static final Map<Status, InstanceInfo.InstanceStatus> STATUS_MAPPING = new HashMap<Status, InstanceInfo.InstanceStatus>(){
        {
            this.put(Status.UNKNOWN, InstanceInfo.InstanceStatus.UNKNOWN);
            this.put(Status.OUT_OF_SERVICE, InstanceInfo.InstanceStatus.OUT_OF_SERVICE);
            this.put(Status.DOWN, InstanceInfo.InstanceStatus.DOWN);
            this.put(Status.UP, InstanceInfo.InstanceStatus.UP);
        }
    };
    private final CompositeHealthIndicator healthIndicator;
    private ApplicationContext applicationContext;

    public EurekaHealthCheckHandler(HealthAggregator healthAggregator) {
        Assert.notNull((Object)healthAggregator, (String)"HealthAggregator must not be null");
        this.healthIndicator = new CompositeHealthIndicator(healthAggregator);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Map healthIndicators = this.applicationContext.getBeansOfType(HealthIndicator.class);
        for (Map.Entry entry : healthIndicators.entrySet()) {
            this.healthIndicator.addHealthIndicator((String)entry.getKey(), (HealthIndicator)entry.getValue());
        }
    }

    public InstanceInfo.InstanceStatus getStatus(InstanceInfo.InstanceStatus instanceStatus) {
        return this.getHealthStatus();
    }

    protected InstanceInfo.InstanceStatus getHealthStatus() {
        Status status = this.healthIndicator.health().getStatus();
        return this.mapToInstanceStatus(status);
    }

    protected InstanceInfo.InstanceStatus mapToInstanceStatus(Status status) {
        if (!STATUS_MAPPING.containsKey(status)) {
            return InstanceInfo.InstanceStatus.UNKNOWN;
        }
        return STATUS_MAPPING.get(status);
    }
}

