/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.discovery.shared.transport.EurekaTransportConfig;

public class CloudEurekaTransportConfig
implements EurekaTransportConfig {
    private int sessionedClientReconnectIntervalSeconds = 1200;
    private double retryableClientQuarantineRefreshPercentage = 0.66;
    private int bootstrapResolverRefreshIntervalSeconds = 300;
    private int applicationsResolverDataStalenessThresholdSeconds = 300;
    private int asyncResolverRefreshIntervalMs = 300000;
    private int asyncResolverWarmUpTimeoutMs = 5000;
    private int asyncExecutorThreadPoolSize = 5;
    private String readClusterVip;
    private String writeClusterVip;
    private boolean bootstrapResolverForQuery = true;
    private String bootstrapResolverStrategy;
    private boolean applicationsResolverUseIp = false;

    public boolean useBootstrapResolverForQuery() {
        return this.bootstrapResolverForQuery;
    }

    public boolean applicationsResolverUseIp() {
        return this.applicationsResolverUseIp;
    }

    public int getSessionedClientReconnectIntervalSeconds() {
        return this.sessionedClientReconnectIntervalSeconds;
    }

    public double getRetryableClientQuarantineRefreshPercentage() {
        return this.retryableClientQuarantineRefreshPercentage;
    }

    public int getBootstrapResolverRefreshIntervalSeconds() {
        return this.bootstrapResolverRefreshIntervalSeconds;
    }

    public int getApplicationsResolverDataStalenessThresholdSeconds() {
        return this.applicationsResolverDataStalenessThresholdSeconds;
    }

    public int getAsyncResolverRefreshIntervalMs() {
        return this.asyncResolverRefreshIntervalMs;
    }

    public int getAsyncResolverWarmUpTimeoutMs() {
        return this.asyncResolverWarmUpTimeoutMs;
    }

    public int getAsyncExecutorThreadPoolSize() {
        return this.asyncExecutorThreadPoolSize;
    }

    public String getReadClusterVip() {
        return this.readClusterVip;
    }

    public String getWriteClusterVip() {
        return this.writeClusterVip;
    }

    public boolean isBootstrapResolverForQuery() {
        return this.bootstrapResolverForQuery;
    }

    public String getBootstrapResolverStrategy() {
        return this.bootstrapResolverStrategy;
    }

    public boolean isApplicationsResolverUseIp() {
        return this.applicationsResolverUseIp;
    }

    public void setSessionedClientReconnectIntervalSeconds(int sessionedClientReconnectIntervalSeconds) {
        this.sessionedClientReconnectIntervalSeconds = sessionedClientReconnectIntervalSeconds;
    }

    public void setRetryableClientQuarantineRefreshPercentage(double retryableClientQuarantineRefreshPercentage) {
        this.retryableClientQuarantineRefreshPercentage = retryableClientQuarantineRefreshPercentage;
    }

    public void setBootstrapResolverRefreshIntervalSeconds(int bootstrapResolverRefreshIntervalSeconds) {
        this.bootstrapResolverRefreshIntervalSeconds = bootstrapResolverRefreshIntervalSeconds;
    }

    public void setApplicationsResolverDataStalenessThresholdSeconds(int applicationsResolverDataStalenessThresholdSeconds) {
        this.applicationsResolverDataStalenessThresholdSeconds = applicationsResolverDataStalenessThresholdSeconds;
    }

    public void setAsyncResolverRefreshIntervalMs(int asyncResolverRefreshIntervalMs) {
        this.asyncResolverRefreshIntervalMs = asyncResolverRefreshIntervalMs;
    }

    public void setAsyncResolverWarmUpTimeoutMs(int asyncResolverWarmUpTimeoutMs) {
        this.asyncResolverWarmUpTimeoutMs = asyncResolverWarmUpTimeoutMs;
    }

    public void setAsyncExecutorThreadPoolSize(int asyncExecutorThreadPoolSize) {
        this.asyncExecutorThreadPoolSize = asyncExecutorThreadPoolSize;
    }

    public void setReadClusterVip(String readClusterVip) {
        this.readClusterVip = readClusterVip;
    }

    public void setWriteClusterVip(String writeClusterVip) {
        this.writeClusterVip = writeClusterVip;
    }

    public void setBootstrapResolverForQuery(boolean bootstrapResolverForQuery) {
        this.bootstrapResolverForQuery = bootstrapResolverForQuery;
    }

    public void setBootstrapResolverStrategy(String bootstrapResolverStrategy) {
        this.bootstrapResolverStrategy = bootstrapResolverStrategy;
    }

    public void setApplicationsResolverUseIp(boolean applicationsResolverUseIp) {
        this.applicationsResolverUseIp = applicationsResolverUseIp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudEurekaTransportConfig)) {
            return false;
        }
        CloudEurekaTransportConfig other = (CloudEurekaTransportConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSessionedClientReconnectIntervalSeconds() != other.getSessionedClientReconnectIntervalSeconds()) {
            return false;
        }
        if (Double.compare(this.getRetryableClientQuarantineRefreshPercentage(), other.getRetryableClientQuarantineRefreshPercentage()) != 0) {
            return false;
        }
        if (this.getBootstrapResolverRefreshIntervalSeconds() != other.getBootstrapResolverRefreshIntervalSeconds()) {
            return false;
        }
        if (this.getApplicationsResolverDataStalenessThresholdSeconds() != other.getApplicationsResolverDataStalenessThresholdSeconds()) {
            return false;
        }
        if (this.getAsyncResolverRefreshIntervalMs() != other.getAsyncResolverRefreshIntervalMs()) {
            return false;
        }
        if (this.getAsyncResolverWarmUpTimeoutMs() != other.getAsyncResolverWarmUpTimeoutMs()) {
            return false;
        }
        if (this.getAsyncExecutorThreadPoolSize() != other.getAsyncExecutorThreadPoolSize()) {
            return false;
        }
        String this$readClusterVip = this.getReadClusterVip();
        String other$readClusterVip = other.getReadClusterVip();
        if (this$readClusterVip == null ? other$readClusterVip != null : !this$readClusterVip.equals(other$readClusterVip)) {
            return false;
        }
        String this$writeClusterVip = this.getWriteClusterVip();
        String other$writeClusterVip = other.getWriteClusterVip();
        if (this$writeClusterVip == null ? other$writeClusterVip != null : !this$writeClusterVip.equals(other$writeClusterVip)) {
            return false;
        }
        if (this.isBootstrapResolverForQuery() != other.isBootstrapResolverForQuery()) {
            return false;
        }
        String this$bootstrapResolverStrategy = this.getBootstrapResolverStrategy();
        String other$bootstrapResolverStrategy = other.getBootstrapResolverStrategy();
        if (this$bootstrapResolverStrategy == null ? other$bootstrapResolverStrategy != null : !this$bootstrapResolverStrategy.equals(other$bootstrapResolverStrategy)) {
            return false;
        }
        return this.isApplicationsResolverUseIp() == other.isApplicationsResolverUseIp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CloudEurekaTransportConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSessionedClientReconnectIntervalSeconds();
        long $retryableClientQuarantineRefreshPercentage = Double.doubleToLongBits(this.getRetryableClientQuarantineRefreshPercentage());
        result = result * 59 + (int)($retryableClientQuarantineRefreshPercentage >>> 32 ^ $retryableClientQuarantineRefreshPercentage);
        result = result * 59 + this.getBootstrapResolverRefreshIntervalSeconds();
        result = result * 59 + this.getApplicationsResolverDataStalenessThresholdSeconds();
        result = result * 59 + this.getAsyncResolverRefreshIntervalMs();
        result = result * 59 + this.getAsyncResolverWarmUpTimeoutMs();
        result = result * 59 + this.getAsyncExecutorThreadPoolSize();
        String $readClusterVip = this.getReadClusterVip();
        result = result * 59 + ($readClusterVip == null ? 43 : $readClusterVip.hashCode());
        String $writeClusterVip = this.getWriteClusterVip();
        result = result * 59 + ($writeClusterVip == null ? 43 : $writeClusterVip.hashCode());
        result = result * 59 + (this.isBootstrapResolverForQuery() ? 79 : 97);
        String $bootstrapResolverStrategy = this.getBootstrapResolverStrategy();
        result = result * 59 + ($bootstrapResolverStrategy == null ? 43 : $bootstrapResolverStrategy.hashCode());
        result = result * 59 + (this.isApplicationsResolverUseIp() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CloudEurekaTransportConfig(sessionedClientReconnectIntervalSeconds=" + this.getSessionedClientReconnectIntervalSeconds() + ", retryableClientQuarantineRefreshPercentage=" + this.getRetryableClientQuarantineRefreshPercentage() + ", bootstrapResolverRefreshIntervalSeconds=" + this.getBootstrapResolverRefreshIntervalSeconds() + ", applicationsResolverDataStalenessThresholdSeconds=" + this.getApplicationsResolverDataStalenessThresholdSeconds() + ", asyncResolverRefreshIntervalMs=" + this.getAsyncResolverRefreshIntervalMs() + ", asyncResolverWarmUpTimeoutMs=" + this.getAsyncResolverWarmUpTimeoutMs() + ", asyncExecutorThreadPoolSize=" + this.getAsyncExecutorThreadPoolSize() + ", readClusterVip=" + this.getReadClusterVip() + ", writeClusterVip=" + this.getWriteClusterVip() + ", bootstrapResolverForQuery=" + this.isBootstrapResolverForQuery() + ", bootstrapResolverStrategy=" + this.getBootstrapResolverStrategy() + ", applicationsResolverUseIp=" + this.isApplicationsResolverUseIp() + ")";
    }
}

