/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.netflix.eureka.EurekaHealthCheckHandler;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaAutoServiceRegistration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaClientConfig.class})
@ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
public class EurekaDiscoveryClientConfiguration {
    @Bean
    public Marker eurekaDiscoverClientMarker() {
        return new Marker();
    }

    @Configuration
    @ConditionalOnProperty(value={"eureka.client.healthcheck.enabled"}, matchIfMissing=false)
    protected static class EurekaHealthCheckHandlerConfiguration {
        @Autowired(required=false)
        private HealthAggregator healthAggregator = new OrderedHealthAggregator();

        protected EurekaHealthCheckHandlerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={HealthCheckHandler.class})
        public EurekaHealthCheckHandler eurekaHealthCheckHandler() {
            return new EurekaHealthCheckHandler(this.healthAggregator);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RefreshScopeRefreshedEvent.class})
    protected static class EurekaClientConfigurationRefresher {
        @Autowired(required=false)
        private EurekaClient eurekaClient;
        @Autowired(required=false)
        private EurekaAutoServiceRegistration autoRegistration;

        protected EurekaClientConfigurationRefresher() {
        }

        @EventListener(value={RefreshScopeRefreshedEvent.class})
        public void onApplicationEvent(RefreshScopeRefreshedEvent event) {
            if (this.eurekaClient != null) {
                this.eurekaClient.getApplications();
            }
            if (this.autoRegistration != null) {
                this.autoRegistration.stop();
                this.autoRegistration.start();
            }
        }
    }

    class Marker {
        Marker() {
        }
    }
}

