/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.configuration.SSLContextFactory;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.RestClientTimeoutProperties;
import org.springframework.cloud.netflix.eureka.RestTemplateTimeoutProperties;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestClientDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.RestClientTransportClientFactories;
import org.springframework.cloud.netflix.eureka.http.RestTemplateDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactories;
import org.springframework.cloud.netflix.eureka.http.WebClientDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.WebClientTransportClientFactories;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RestTemplateTimeoutProperties.class, RestClientTimeoutProperties.class})
public class DiscoveryClientOptionalArgsConfiguration {
    protected static final Log logger = LogFactory.getLog(DiscoveryClientOptionalArgsConfiguration.class);

    @Bean
    @ConfigurationProperties(value="eureka.client.tls")
    public TlsProperties tlsProperties() {
        return new TlsProperties();
    }

    public static void setupTLS(AbstractDiscoveryClientOptionalArgs<?> args, TlsProperties properties) throws GeneralSecurityException, IOException {
        if (properties.isEnabled()) {
            SSLContextFactory factory = new SSLContextFactory(properties);
            args.setSSLContext(factory.createSSLContext());
        }
    }

    static class OnRestClientPresentAndEnabledCondition
    extends AllNestedConditions {
        OnRestClientPresentAndEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="eureka.client", name={"restclient.enabled"}, havingValue="true")
        static class OnRestClientEnabled {
            OnRestClientEnabled() {
            }
        }

        @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, matchIfMissing=true, havingValue="false")
        static class OnWebClientDisabled {
            OnWebClientDisabled() {
            }
        }

        @Conditional(value={OnJerseyClientNotPresentOrNotEnabledCondition.class})
        static class OnJerseyClientNotPresentOrNotEnabled {
            OnJerseyClientNotPresentOrNotEnabled() {
            }
        }

        @ConditionalOnClass(name={"org.springframework.web.client.RestClient"})
        static class OnRestClientPresent {
            OnRestClientPresent() {
            }
        }
    }

    @Deprecated(forRemoval=true)
    static class OnRestTemplatePresentAndEnabledCondition
    extends AllNestedConditions {
        OnRestTemplatePresentAndEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="eureka.client", name={"restclient.enabled"}, havingValue="false", matchIfMissing=true)
        static class OnRestClientDisabled {
            OnRestClientDisabled() {
            }
        }

        @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, matchIfMissing=true, havingValue="false")
        static class OnWebClientDisabled {
            OnWebClientDisabled() {
            }
        }

        @Conditional(value={OnJerseyClientNotPresentOrNotEnabledCondition.class})
        static class OnJerseyClientNotPresentOrNotEnabled {
            OnJerseyClientNotPresentOrNotEnabled() {
            }
        }

        @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
        static class OnRestTemplatePresent {
            OnRestTemplatePresent() {
            }
        }
    }

    static class OnJerseyClientNotPresentOrNotEnabledCondition
    extends AnyNestedCondition {
        OnJerseyClientNotPresentOrNotEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"eureka.client.jersey.enabled"}, havingValue="false")
        static class OnJerseyClientDisabled {
            OnJerseyClientDisabled() {
            }
        }

        @ConditionalOnMissingClass(value={"org.glassfish.jersey.client.JerseyClient"})
        static class OnJerseyClientMissing {
            OnJerseyClientMissing() {
            }
        }
    }

    static class OnJerseyClientPresentAndEnabledCondition
    extends AllNestedConditions {
        OnJerseyClientPresentAndEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"eureka.client.jersey.enabled"}, matchIfMissing=true)
        static class OnJerseyClientEnabled {
            OnJerseyClientEnabled() {
            }
        }

        @ConditionalOnClass(name={"org.glassfish.jersey.client.JerseyClient"})
        static class OnJerseyClientPresent {
            OnJerseyClientPresent() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnRestClientPresentAndEnabledCondition.class})
    protected static class RestClientConfiguration {
        protected RestClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        EurekaClientHttpRequestFactorySupplier defaultEurekaClientHttpRequestFactorySupplier(RestClientTimeoutProperties restClientTimeoutProperties, Set<EurekaClientHttpRequestFactorySupplier.RequestConfigCustomizer> requestConfigCustomizers) {
            return new DefaultEurekaClientHttpRequestFactorySupplier(restClientTimeoutProperties, requestConfigCustomizers);
        }

        @Bean
        @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
        public RestClientDiscoveryClientOptionalArgs restClientDiscoveryClientOptionalArgs(TlsProperties tlsProperties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier, ObjectProvider<RestClient.Builder> restClientBuilderProvider) throws GeneralSecurityException, IOException {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Eureka HTTP Client uses RestClient.");
            }
            RestClientDiscoveryClientOptionalArgs result = new RestClientDiscoveryClientOptionalArgs(eurekaClientHttpRequestFactorySupplier, () -> (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder));
            DiscoveryClientOptionalArgsConfiguration.setupTLS(result, tlsProperties);
            return result;
        }

        @Bean
        @ConditionalOnMissingBean(value={TransportClientFactories.class}, search=SearchStrategy.CURRENT)
        public RestClientTransportClientFactories restClientTransportClientFactories(RestClientDiscoveryClientOptionalArgs args) {
            return new RestClientTransportClientFactories(args);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnJerseyClientNotPresentOrNotEnabledCondition.class})
    @ConditionalOnMissingClass(value={"org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, havingValue="true")
    protected static class WebClientNotFoundConfiguration {
        public WebClientNotFoundConfiguration() {
            throw new IllegalStateException("eureka.client.webclient.enabled is true, but WebClient is not on the classpath. Please add spring-boot-starter-webflux as a dependency.");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnJerseyClientNotPresentOrNotEnabledCondition.class})
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, havingValue="true")
    protected static class WebClientConfiguration {
        protected WebClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class, RestTemplateDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
        public WebClientDiscoveryClientOptionalArgs webClientDiscoveryClientOptionalArgs(TlsProperties tlsProperties, ObjectProvider<WebClient.Builder> builder) throws GeneralSecurityException, IOException {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Eureka HTTP Client uses WebClient.");
            }
            WebClientDiscoveryClientOptionalArgs result = new WebClientDiscoveryClientOptionalArgs(() -> builder.getIfAvailable());
            DiscoveryClientOptionalArgsConfiguration.setupTLS(result, tlsProperties);
            return result;
        }

        @Bean
        @ConditionalOnMissingBean(value={TransportClientFactories.class}, search=SearchStrategy.CURRENT)
        public WebClientTransportClientFactories webClientTransportClientFactories(ObjectProvider<WebClient.Builder> builder) {
            return new WebClientTransportClientFactories(() -> builder.getIfAvailable());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnJerseyClientPresentAndEnabledCondition.class})
    @ConditionalOnBean(value={AbstractDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
    static class DiscoveryClientOptionalArgsTlsConfiguration {
        DiscoveryClientOptionalArgsTlsConfiguration(TlsProperties tlsProperties, AbstractDiscoveryClientOptionalArgs optionalArgs) throws GeneralSecurityException, IOException {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Eureka HTTP Client uses Jersey");
            }
            DiscoveryClientOptionalArgsConfiguration.setupTLS(optionalArgs, tlsProperties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnRestTemplatePresentAndEnabledCondition.class})
    @Deprecated
    static class RestTemplateConfiguration {
        RestTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        EurekaClientHttpRequestFactorySupplier defaultEurekaClientHttpRequestFactorySupplier(RestTemplateTimeoutProperties restTemplateTimeoutProperties, Set<EurekaClientHttpRequestFactorySupplier.RequestConfigCustomizer> requestConfigCustomizers) {
            return new DefaultEurekaClientHttpRequestFactorySupplier(restTemplateTimeoutProperties, requestConfigCustomizers);
        }

        @Bean
        @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
        public RestTemplateDiscoveryClientOptionalArgs restTemplateDiscoveryClientOptionalArgs(TlsProperties tlsProperties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier, ObjectProvider<RestTemplateBuilder> restTemplateBuilders) throws GeneralSecurityException, IOException {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Eureka HTTP Client uses RestTemplate.");
            }
            RestTemplateDiscoveryClientOptionalArgs result = new RestTemplateDiscoveryClientOptionalArgs(eurekaClientHttpRequestFactorySupplier, () -> restTemplateBuilders.getIfAvailable());
            DiscoveryClientOptionalArgsConfiguration.setupTLS(result, tlsProperties);
            return result;
        }

        @Bean
        @ConditionalOnMissingBean(value={TransportClientFactories.class}, search=SearchStrategy.CURRENT)
        public RestTemplateTransportClientFactories restTemplateTransportClientFactories(RestTemplateDiscoveryClientOptionalArgs optionalArgs) {
            return new RestTemplateTransportClientFactories(optionalArgs);
        }
    }
}

