/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.server.EurekaController;
import org.springframework.cloud.netflix.eureka.server.EurekaDashboardProperties;
import org.springframework.cloud.netflix.eureka.server.EurekaServerInitializerConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@Import(value={EurekaServerInitializerConfiguration.class})
@EnableDiscoveryClient
@EnableConfigurationProperties(value={EurekaDashboardProperties.class})
public class EurekaServerConfiguration
extends WebMvcConfigurerAdapter {
    @Bean
    @ConditionalOnProperty(prefix="eureka.dashboard", name={"enabled"}, matchIfMissing=true)
    public EurekaController eurekaController() {
        return new EurekaController();
    }

    @Bean
    public FilterRegistrationBean jersey() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ServletContainer());
        bean.setOrder(Integer.MAX_VALUE);
        bean.addInitParameter("com.sun.jersey.config.property.WebPageContentRegex", "/eureka/(fonts|images|css|js)/.*");
        bean.addInitParameter("com.sun.jersey.config.property.packages", "com.netflix.discovery;com.netflix.eureka");
        bean.setUrlPatterns(Collections.singletonList("/eureka/*"));
        return bean;
    }

    @Bean
    public FilterRegistrationBean traceFilterRegistration(@Qualifier(value="webRequestLoggingFilter") Filter filter) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter(filter);
        bean.setOrder(0x7FFFFFF5);
        return bean;
    }
}

