/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Pair;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.resources.StatusResource;
import com.netflix.eureka.util.StatusInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"${eureka.dashboard.path:/}"})
public class EurekaController {
    @Value(value="${eureka.dashboard.path:/}")
    private String dashboardPath = "";
    private ApplicationInfoManager applicationInfoManager;

    public EurekaController(ApplicationInfoManager applicationInfoManager) {
        this.applicationInfoManager = applicationInfoManager;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String status(HttpServletRequest request, Map<String, Object> model) {
        StatusInfo statusInfo;
        this.populateBase(request, model);
        this.populateApps(model);
        try {
            statusInfo = new StatusResource().getStatusInfo();
        }
        catch (Exception e) {
            statusInfo = StatusInfo.Builder.newBuilder().isHealthy(false).build();
        }
        model.put("statusInfo", statusInfo);
        this.populateInstanceInfo(model, statusInfo);
        this.filterReplicas(model, statusInfo);
        return "eureka/status";
    }

    @RequestMapping(value={"/lastn"}, method={RequestMethod.GET})
    public String lastn(HttpServletRequest request, Map<String, Object> model) {
        this.populateBase(request, model);
        PeerAwareInstanceRegistryImpl registry = (PeerAwareInstanceRegistryImpl)this.getRegistry();
        ArrayList<Map<String, Object>> lastNCanceled = new ArrayList<Map<String, Object>>();
        List list = registry.getLastNCanceledInstances();
        for (Pair entry : list) {
            lastNCanceled.add(this.registeredInstance((String)entry.second(), (Long)entry.first()));
        }
        model.put("lastNCanceled", lastNCanceled);
        list = registry.getLastNRegisteredInstances();
        ArrayList<Map<String, Object>> lastNRegistered = new ArrayList<Map<String, Object>>();
        for (Pair entry : list) {
            lastNRegistered.add(this.registeredInstance((String)entry.second(), (Long)entry.first()));
        }
        model.put("lastNRegistered", lastNRegistered);
        return "eureka/lastn";
    }

    private Map<String, Object> registeredInstance(String id, long date) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("date", new Date(date));
        return map;
    }

    protected void populateBase(HttpServletRequest request, Map<String, Object> model) {
        model.put("time", new Date());
        model.put("basePath", "/");
        model.put("dashboardPath", this.dashboardPath.equals("/") ? "" : this.dashboardPath);
        this.populateHeader(model);
        this.populateNavbar(request, model);
    }

    private void populateHeader(Map<String, Object> model) {
        model.put("currentTime", StatusResource.getCurrentTimeAsString());
        model.put("upTime", StatusInfo.getUpTime());
        model.put("environment", ConfigurationManager.getDeploymentContext().getDeploymentEnvironment());
        model.put("datacenter", ConfigurationManager.getDeploymentContext().getDeploymentDatacenter());
        PeerAwareInstanceRegistry registry = this.getRegistry();
        model.put("registry", registry);
        model.put("isBelowRenewThresold", registry.isBelowRenewThresold() == 1);
        DataCenterInfo info = this.applicationInfoManager.getInfo().getDataCenterInfo();
        if (info.getName() == DataCenterInfo.Name.Amazon) {
            AmazonInfo amazonInfo = (AmazonInfo)info;
            model.put("amazonInfo", amazonInfo);
            model.put("amiId", amazonInfo.get(AmazonInfo.MetaDataKey.amiId));
            model.put("availabilityZone", amazonInfo.get(AmazonInfo.MetaDataKey.availabilityZone));
            model.put("instanceId", amazonInfo.get(AmazonInfo.MetaDataKey.instanceId));
        }
    }

    private PeerAwareInstanceRegistry getRegistry() {
        return this.getServerContext().getRegistry();
    }

    private EurekaServerContext getServerContext() {
        return EurekaServerContextHolder.getInstance().getServerContext();
    }

    private void populateNavbar(HttpServletRequest request, Map<String, Object> model) {
        LinkedHashMap<String, String> replicas = new LinkedHashMap<String, String>();
        List list = this.getServerContext().getPeerEurekaNodes().getPeerNodesView();
        for (PeerEurekaNode node : list) {
            try {
                URI uri = new URI(node.getServiceUrl());
                String href = this.scrubBasicAuth(node.getServiceUrl());
                replicas.put(uri.getHost(), href);
            }
            catch (Exception exception) {}
        }
        model.put("replicas", replicas.entrySet());
    }

    private void populateApps(Map<String, Object> model) {
        List sortedApplications = this.getRegistry().getSortedApplications();
        ArrayList apps = new ArrayList();
        for (Application app : sortedApplications) {
            InstanceInfo.InstanceStatus status;
            LinkedHashMap<String, Object> appData = new LinkedHashMap<String, Object>();
            apps.add(appData);
            appData.put("name", app.getName());
            HashMap<String, Integer> amiCounts = new HashMap<String, Integer>();
            HashMap<InstanceInfo.InstanceStatus, ArrayList<Pair>> instancesByStatus = new HashMap<InstanceInfo.InstanceStatus, ArrayList<Pair>>();
            HashMap<String, Integer> zoneCounts = new HashMap<String, Integer>();
            for (InstanceInfo info : app.getInstances()) {
                Integer count;
                String id = info.getId();
                String url = info.getStatusPageUrl();
                status = info.getStatus();
                String ami = "n/a";
                String zone = "";
                if (info.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon) {
                    AmazonInfo dcInfo = (AmazonInfo)info.getDataCenterInfo();
                    ami = dcInfo.get(AmazonInfo.MetaDataKey.amiId);
                    zone = dcInfo.get(AmazonInfo.MetaDataKey.availabilityZone);
                }
                if ((count = (Integer)amiCounts.get(ami)) != null) {
                    amiCounts.put(ami, count + 1);
                } else {
                    amiCounts.put(ami, 1);
                }
                count = (Integer)zoneCounts.get(zone);
                if (count != null) {
                    zoneCounts.put(zone, count + 1);
                } else {
                    zoneCounts.put(zone, 1);
                }
                ArrayList<Pair> list = (ArrayList<Pair>)instancesByStatus.get(status);
                if (list == null) {
                    list = new ArrayList<Pair>();
                    instancesByStatus.put(status, list);
                }
                list.add(new Pair((Object)id, (Object)url));
            }
            appData.put("amiCounts", amiCounts.entrySet());
            appData.put("zoneCounts", zoneCounts.entrySet());
            ArrayList instanceInfos = new ArrayList();
            appData.put("instanceInfos", instanceInfos);
            for (Map.Entry entry : instancesByStatus.entrySet()) {
                List value = (List)entry.getValue();
                status = (InstanceInfo.InstanceStatus)entry.getKey();
                LinkedHashMap<String, Object> instanceData = new LinkedHashMap<String, Object>();
                instanceInfos.add(instanceData);
                instanceData.put("status", entry.getKey());
                ArrayList instances = new ArrayList();
                instanceData.put("instances", instances);
                instanceData.put("isNotUp", status != InstanceInfo.InstanceStatus.UP);
                for (Pair p : value) {
                    LinkedHashMap<String, Object> instance = new LinkedHashMap<String, Object>();
                    instances.add(instance);
                    instance.put("id", p.first());
                    String url = (String)p.second();
                    instance.put("url", url);
                    boolean isHref = url != null && url.startsWith("http");
                    instance.put("isHref", isHref);
                }
            }
        }
        model.put("apps", apps);
    }

    private void populateInstanceInfo(Map<String, Object> model, StatusInfo statusInfo) {
        InstanceInfo instanceInfo = statusInfo.getInstanceInfo();
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        instanceMap.put("ipAddr", instanceInfo.getIPAddr());
        instanceMap.put("status", instanceInfo.getStatus().toString());
        if (instanceInfo.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon) {
            AmazonInfo info = (AmazonInfo)instanceInfo.getDataCenterInfo();
            instanceMap.put("availability-zone", info.get(AmazonInfo.MetaDataKey.availabilityZone));
            instanceMap.put("public-ipv4", info.get(AmazonInfo.MetaDataKey.publicIpv4));
            instanceMap.put("instance-id", info.get(AmazonInfo.MetaDataKey.instanceId));
            instanceMap.put("public-hostname", info.get(AmazonInfo.MetaDataKey.publicHostname));
            instanceMap.put("ami-id", info.get(AmazonInfo.MetaDataKey.amiId));
            instanceMap.put("instance-type", info.get(AmazonInfo.MetaDataKey.instanceType));
        }
        model.put("instanceInfo", instanceMap);
    }

    protected void filterReplicas(Map<String, Object> model, StatusInfo statusInfo) {
        Map applicationStats = statusInfo.getApplicationStats();
        if (((String)applicationStats.get("registered-replicas")).contains("@")) {
            applicationStats.put("registered-replicas", this.scrubBasicAuth((String)applicationStats.get("registered-replicas")));
        }
        if (((String)applicationStats.get("unavailable-replicas")).contains("@")) {
            applicationStats.put("unavailable-replicas", this.scrubBasicAuth((String)applicationStats.get("unavailable-replicas")));
        }
        if (((String)applicationStats.get("available-replicas")).contains("@")) {
            applicationStats.put("available-replicas", this.scrubBasicAuth((String)applicationStats.get("available-replicas")));
        }
        model.put("applicationStats", applicationStats);
    }

    private String scrubBasicAuth(String urlList) {
        String[] urls = urlList.split(",");
        String filteredUrls = "";
        for (String u : urls) {
            filteredUrls = u.contains("@") ? filteredUrls + u.substring(0, u.indexOf("//") + 2) + u.substring(u.indexOf("@") + 1, u.length()) + "," : filteredUrls + u + ",";
        }
        return filteredUrls.substring(0, filteredUrls.length() - 1);
    }
}

