/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix.stream;

import com.netflix.hystrix.HystrixCircuitBreaker;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.netflix.hystrix.stream.HystrixStreamClient;
import org.springframework.cloud.netflix.hystrix.stream.HystrixStreamProperties;
import org.springframework.cloud.netflix.hystrix.stream.HystrixStreamTask;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnClass(value={HystrixCircuitBreaker.class, EnableBinding.class})
@ConditionalOnProperty(value={"hystrix.stream.queue.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties
@EnableScheduling
@EnableBinding(value={HystrixStreamClient.class})
public class HystrixStreamAutoConfiguration {
    @Autowired
    private ChannelBindingServiceProperties bindings;
    @Autowired
    private HystrixStreamProperties properties;

    @Bean
    public HasFeatures hystrixStreamQueueFeature() {
        return HasFeatures.namedFeature((String)"Hystrix Stream (Queue)", HystrixStreamAutoConfiguration.class);
    }

    @PostConstruct
    public void init() {
        BindingProperties output;
        BindingProperties outputBinding = (BindingProperties)this.bindings.getBindings().get("hystrixStreamOutput");
        if (outputBinding == null) {
            this.bindings.getBindings().put("hystrixStreamOutput", new BindingProperties());
        }
        if ((output = (BindingProperties)this.bindings.getBindings().get("hystrixStreamOutput")).getDestination() == null) {
            output.setDestination(this.properties.getDestination());
        }
        if (output.getContentType() == null) {
            output.setContentType(this.properties.getContentType());
        }
    }

    @Bean
    public HystrixStreamProperties hystrixStreamProperties() {
        return new HystrixStreamProperties();
    }

    @Bean
    public HystrixStreamTask hystrixStreamTask() {
        return new HystrixStreamTask();
    }
}

