/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="hystrix.metrics")
public class HystrixMetricsProperties {
    private boolean enabled = true;
    private Integer pollingIntervalMs = 2000;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getPollingIntervalMs() {
        return this.pollingIntervalMs;
    }

    public void setPollingIntervalMs(Integer pollingIntervalMs) {
        this.pollingIntervalMs = pollingIntervalMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HystrixMetricsProperties that = (HystrixMetricsProperties)o;
        return this.enabled == that.enabled && Objects.equals(this.pollingIntervalMs, that.pollingIntervalMs);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.pollingIntervalMs);
    }

    public String toString() {
        return "HystrixMetricsProperties{" + "enabled=" + this.enabled + ", " + "pollingIntervalMs=" + this.pollingIntervalMs + "}";
    }
}

