/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.discovery.InstanceDiscovery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.turbine.TurbineProperties;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class EurekaInstanceDiscovery
implements InstanceDiscovery {
    private static final Log log = LogFactory.getLog(EurekaInstanceDiscovery.class);
    private static final DynamicStringProperty ApplicationList = DynamicPropertyFactory.getInstance().getStringProperty("turbine.appConfig", "");
    private final Expression clusterNameExpression;

    public EurekaInstanceDiscovery(TurbineProperties turbineProperties) {
        SpelExpressionParser parser = new SpelExpressionParser();
        this.clusterNameExpression = parser.parseExpression(turbineProperties.getClusterNameExpression());
    }

    public Collection<Instance> getInstanceList() throws Exception {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        List<String> appNames = this.parseApps();
        if (appNames == null || appNames.size() == 0) {
            log.info((Object)"No apps configured, returning an empty instance list");
            return instances;
        }
        log.info((Object)("Fetching instance list for apps: " + appNames));
        for (String appName : appNames) {
            try {
                instances.addAll(this.getInstancesForApp(appName));
            }
            catch (Exception ex) {
                log.error((Object)("Failed to fetch instances for app: " + appName + ", retrying once more"), (Throwable)ex);
                try {
                    instances.addAll(this.getInstancesForApp(appName));
                }
                catch (Exception retryException) {
                    log.error((Object)("Failed again to fetch instances for app: " + appName + ", giving up"), (Throwable)ex);
                }
            }
        }
        return instances;
    }

    private List<Instance> getInstancesForApp(String appName) throws Exception {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        log.info((Object)("Fetching instances for app: " + appName));
        DiscoveryClient client = DiscoveryManager.getInstance().getDiscoveryClient();
        if (client == null) {
            log.info((Object)("Discovery client not ready for: " + appName));
            return instances;
        }
        Application app = client.getApplication(appName);
        if (app == null) {
            log.warn((Object)("Eureka returned null for app: " + appName));
        }
        try {
            List instancesForApp = app.getInstances();
            if (instancesForApp != null) {
                log.info((Object)("Received instance list for app: " + appName + ", size=" + instancesForApp.size()));
                for (InstanceInfo iInfo : instancesForApp) {
                    Instance instance = this.marshallInstanceInfo(iInfo);
                    if (instance == null) continue;
                    instances.add(instance);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to retrieve instances from Eureka", (Throwable)e);
        }
        return instances;
    }

    protected Instance marshallInstanceInfo(InstanceInfo instanceInfo) {
        String hostname = instanceInfo.getHostName();
        String cluster = this.getClusterName(instanceInfo);
        Boolean status = this.parseInstanceStatus(instanceInfo.getStatus());
        if (hostname != null && cluster != null && status != null) {
            String asgName;
            Instance instance = new Instance(hostname, cluster, status.booleanValue());
            Map metadata = instanceInfo.getMetadata();
            if (metadata != null) {
                instance.getAttributes().putAll(metadata);
            }
            if ((asgName = instanceInfo.getASGName()) != null) {
                instance.getAttributes().put("asg", asgName);
            }
            instance.getAttributes().put("port", String.valueOf(instanceInfo.getPort()));
            DataCenterInfo dcInfo = instanceInfo.getDataCenterInfo();
            if (dcInfo != null && dcInfo.getName().equals((Object)DataCenterInfo.Name.Amazon)) {
                AmazonInfo amznInfo = (AmazonInfo)dcInfo;
                instance.getAttributes().putAll(amznInfo.getMetadata());
            }
            return instance;
        }
        return null;
    }

    protected Boolean parseInstanceStatus(InstanceInfo.InstanceStatus status) {
        if (status == null) {
            return null;
        }
        return status == InstanceInfo.InstanceStatus.UP;
    }

    protected String getClusterName(InstanceInfo iInfo) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)iInfo);
        Object value = this.clusterNameExpression.getValue((EvaluationContext)context);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private List<String> parseApps() {
        String appList = ApplicationList.get();
        if (appList == null) {
            return null;
        }
        if ((appList = appList.trim()).length() == 0) {
            return null;
        }
        String[] parts = appList.split(",");
        if (parts != null && parts.length > 0) {
            return Arrays.asList(parts);
        }
        return null;
    }
}

