/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.discovery.InstanceDiscovery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.turbine.TurbineProperties;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class CommonsInstanceDiscovery
implements InstanceDiscovery {
    private static final Log log = LogFactory.getLog(CommonsInstanceDiscovery.class);
    private static final String DEFAULT_CLUSTER_NAME_EXPRESSION = "serviceId";
    protected static final String PORT_KEY = "port";
    protected static final String SECURE_PORT_KEY = "securePort";
    protected static final String FUSED_HOST_PORT_KEY = "fusedHostPort";
    private final Expression clusterNameExpression;
    private DiscoveryClient discoveryClient;
    private TurbineProperties turbineProperties;
    private final boolean combineHostPort;

    public CommonsInstanceDiscovery(TurbineProperties turbineProperties, DiscoveryClient discoveryClient) {
        this(turbineProperties, DEFAULT_CLUSTER_NAME_EXPRESSION);
        this.discoveryClient = discoveryClient;
    }

    protected CommonsInstanceDiscovery(TurbineProperties turbineProperties, String defaultExpression) {
        this.turbineProperties = turbineProperties;
        SpelExpressionParser parser = new SpelExpressionParser();
        String clusterNameExpression = turbineProperties.getClusterNameExpression();
        if (clusterNameExpression == null) {
            clusterNameExpression = defaultExpression;
        }
        this.clusterNameExpression = parser.parseExpression(clusterNameExpression);
        this.combineHostPort = turbineProperties.isCombineHostPort();
    }

    protected Expression getClusterNameExpression() {
        return this.clusterNameExpression;
    }

    public TurbineProperties getTurbineProperties() {
        return this.turbineProperties;
    }

    protected boolean isCombineHostPort() {
        return this.combineHostPort;
    }

    public Collection<Instance> getInstanceList() throws Exception {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        List<String> appNames = this.getTurbineProperties().getAppConfigList();
        if (appNames == null || appNames.size() == 0) {
            log.info((Object)"No apps configured, returning an empty instance list");
            return instances;
        }
        log.info((Object)("Fetching instance list for apps: " + appNames));
        for (String appName : appNames) {
            try {
                instances.addAll(this.getInstancesForApp(appName));
            }
            catch (Exception ex) {
                log.error((Object)("Failed to fetch instances for app: " + appName + ", retrying once more"), (Throwable)ex);
                try {
                    instances.addAll(this.getInstancesForApp(appName));
                }
                catch (Exception retryException) {
                    log.error((Object)("Failed again to fetch instances for app: " + appName + ", giving up"), (Throwable)ex);
                }
            }
        }
        return instances;
    }

    protected List<Instance> getInstancesForApp(String serviceId) throws Exception {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        log.info((Object)("Fetching instances for app: " + serviceId));
        List serviceInstances = this.discoveryClient.getInstances(serviceId);
        if (serviceInstances == null || serviceInstances.isEmpty()) {
            log.warn((Object)("DiscoveryClient returned null or empty for service: " + serviceId));
            return instances;
        }
        try {
            log.info((Object)("Received instance list for service: " + serviceId + ", size=" + serviceInstances.size()));
            for (ServiceInstance serviceInstance : serviceInstances) {
                Instance instance = this.marshall(serviceInstance);
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to retrieve instances from DiscoveryClient", (Throwable)e);
        }
        return instances;
    }

    Instance marshall(ServiceInstance serviceInstance) {
        String hostname = serviceInstance.getHost();
        String managementPort = (String)serviceInstance.getMetadata().get("management.port");
        String port = managementPort == null ? String.valueOf(serviceInstance.getPort()) : managementPort;
        String cluster = this.getClusterName(serviceInstance);
        Boolean status = Boolean.TRUE;
        if (hostname != null && cluster != null && status != null) {
            Instance instance = this.getInstance(hostname, port, cluster, status);
            Map metadata = serviceInstance.getMetadata();
            boolean securePortEnabled = serviceInstance.isSecure();
            this.addMetadata(instance, hostname, port, securePortEnabled, port, metadata);
            return instance;
        }
        return null;
    }

    protected void addMetadata(Instance instance, String hostname, String port, boolean securePortEnabled, String securePort, Map<String, String> metadata) {
        if (metadata != null) {
            instance.getAttributes().putAll(metadata);
        }
        instance.getAttributes().put(PORT_KEY, port);
        if (securePortEnabled) {
            instance.getAttributes().put(SECURE_PORT_KEY, securePort);
        }
        if (this.isCombineHostPort()) {
            String fusedHostPort = securePortEnabled ? hostname + ":" + securePort : instance.getHostname();
            instance.getAttributes().put(FUSED_HOST_PORT_KEY, fusedHostPort);
        }
    }

    protected Instance getInstance(String hostname, String port, String cluster, Boolean status) {
        String hostPart = this.isCombineHostPort() ? hostname + ":" + port : hostname;
        return new Instance(hostPart, cluster, status.booleanValue());
    }

    protected String getClusterName(Object object) {
        StandardEvaluationContext context = new StandardEvaluationContext(object);
        Object value = this.clusterNameExpression.getValue((EvaluationContext)context);
        if (value != null) {
            return value.toString();
        }
        return null;
    }
}

