/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.StringUtils;

public class Route {
    private String id;
    private String fullPath;
    private String path;
    private String location;
    private String prefix;
    private Boolean retryable;
    private Set<String> sensitiveHeaders = new LinkedHashSet<String>();
    private boolean customSensitiveHeaders;
    private boolean prefixStripped = true;

    public Route(String id, String path, String location, String prefix, Boolean retryable, Set<String> ignoredHeaders) {
        this.id = id;
        this.prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        this.path = path;
        this.fullPath = prefix + path;
        this.location = location;
        this.retryable = retryable;
        this.sensitiveHeaders = new LinkedHashSet<String>();
        if (ignoredHeaders != null) {
            this.customSensitiveHeaders = true;
            for (String header : ignoredHeaders) {
                this.sensitiveHeaders.add(header.toLowerCase());
            }
        }
    }

    public Route(String id, String path, String location, String prefix, Boolean retryable, Set<String> ignoredHeaders, boolean prefixStripped) {
        this(id, path, location, prefix, retryable, ignoredHeaders);
        this.prefixStripped = prefixStripped;
    }

    public boolean isCustomSensitiveHeaders() {
        return this.customSensitiveHeaders;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    public void setRetryable(Boolean retryable) {
        this.retryable = retryable;
    }

    public Set<String> getSensitiveHeaders() {
        return this.sensitiveHeaders;
    }

    public void setSensitiveHeaders(Set<String> sensitiveHeaders) {
        this.sensitiveHeaders = sensitiveHeaders;
    }

    public void setCustomSensitiveHeaders(boolean customSensitiveHeaders) {
        this.customSensitiveHeaders = customSensitiveHeaders;
    }

    public boolean isPrefixStripped() {
        return this.prefixStripped;
    }

    public void setPrefixStripped(boolean prefixStripped) {
        this.prefixStripped = prefixStripped;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route that = (Route)o;
        return this.customSensitiveHeaders == that.customSensitiveHeaders && this.prefixStripped == that.prefixStripped && Objects.equals(this.id, that.id) && Objects.equals(this.fullPath, that.fullPath) && Objects.equals(this.path, that.path) && Objects.equals(this.location, that.location) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.retryable, that.retryable) && Objects.equals(this.sensitiveHeaders, that.sensitiveHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fullPath, this.path, this.location, this.prefix, this.retryable, this.sensitiveHeaders, this.customSensitiveHeaders, this.prefixStripped);
    }

    public String toString() {
        return "Route{" + "id='" + this.id + "', " + "fullPath='" + this.fullPath + "', " + "path='" + this.path + "', " + "location='" + this.location + "', " + "prefix='" + this.prefix + "', " + "retryable=" + this.retryable + ", " + "sensitiveHeaders=" + this.sensitiveHeaders + ", " + "customSensitiveHeaders=" + this.customSensitiveHeaders + ", " + "prefixStripped=" + this.prefixStripped + "}";
    }
}

