/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.client.config.IClientConfig;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.niws.client.http.RestClient;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.springframework.cloud.netflix.ribbon.support.RibbonCommandContext;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.cloud.netflix.zuul.filters.route.support.AbstractRibbonCommand;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;

public class RestClientRibbonCommand
extends AbstractRibbonCommand<RestClient, HttpRequest, HttpResponse> {
    public RestClientRibbonCommand(String commandKey, RestClient client, RibbonCommandContext context, ZuulProperties zuulProperties) {
        super(commandKey, client, context, zuulProperties);
    }

    public RestClientRibbonCommand(String commandKey, RestClient client, RibbonCommandContext context, ZuulProperties zuulProperties, FallbackProvider zuulFallbackProvider) {
        super(commandKey, client, context, zuulProperties, zuulFallbackProvider);
    }

    public RestClientRibbonCommand(String commandKey, RestClient client, RibbonCommandContext context, ZuulProperties zuulProperties, FallbackProvider zuulFallbackProvider, IClientConfig config) {
        super(commandKey, client, context, zuulProperties, zuulFallbackProvider, config);
    }

    @Deprecated
    public RestClientRibbonCommand(String commandKey, RestClient restClient, HttpRequest.Verb verb, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) {
        this(commandKey, restClient, new RibbonCommandContext(commandKey, verb.verb(), uri, retryable, headers, params, requestEntity), new ZuulProperties());
    }

    @Override
    protected HttpRequest createRequest() throws Exception {
        List values;
        InputStream requestEntity = this.getContext().getMethod().equalsIgnoreCase(HttpMethod.DELETE.toString()) ? null : this.context.getRequestEntity();
        HttpRequest.Builder builder = HttpRequest.newBuilder().verb(RestClientRibbonCommand.getVerb(this.context.getMethod())).uri(this.context.uri()).entity((Object)requestEntity);
        if (this.context.getRetryable() != null) {
            builder.setRetriable(this.context.getRetryable().booleanValue());
        }
        for (String name : this.context.getHeaders().keySet()) {
            values = (List)this.context.getHeaders().get((Object)name);
            for (String value : values) {
                builder.header(name, value);
            }
        }
        for (String name : this.context.getParams().keySet()) {
            values = (List)this.context.getParams().get((Object)name);
            for (String value : values) {
                builder.queryParams(name, value);
            }
        }
        this.customizeRequest(builder);
        return builder.build();
    }

    protected void customizeRequest(HttpRequest.Builder requestBuilder) {
        RibbonRequestCustomizer.Runner.customize((List)this.context.getRequestCustomizers(), (Object)requestBuilder);
    }

    @Deprecated
    public URI getUri() {
        return this.context.uri();
    }

    @Deprecated
    public HttpRequest.Verb getVerb() {
        return RestClientRibbonCommand.getVerb(this.context.getVerb());
    }

    protected static HttpRequest.Verb getVerb(String method) {
        if (method == null) {
            return HttpRequest.Verb.GET;
        }
        try {
            return HttpRequest.Verb.valueOf((String)method.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return HttpRequest.Verb.GET;
        }
    }
}

