/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.client;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.RequestEnhancer;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.util.MultiValueMap;

@Configuration
@EnableOAuth2Client
@EnableConfigurationProperties
public class ClientConfiguration {
    @Resource
    @Qualifier(value="accessTokenRequest")
    private AccessTokenRequest accessTokenRequest;

    @Bean
    public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)filter);
        registration.setOrder(0);
        return registration;
    }

    @Bean
    @ConfigurationProperties(value="spring.oauth2.client")
    @Primary
    public AuthorizationCodeResourceDetails oauth2RemoteResource() {
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        return details;
    }

    @Bean
    public OAuth2RestOperations oauth2RestTemplate() {
        OAuth2RestTemplate template = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)this.oauth2RemoteResource(), this.oauth2ClientContext());
        template.setInterceptors(Arrays.asList(new ClientHttpRequestInterceptor(){

            public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
                request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
                return execution.execute(request, body);
            }
        }));
        AuthorizationCodeAccessTokenProvider accessTokenProvider = new AuthorizationCodeAccessTokenProvider();
        accessTokenProvider.setTokenRequestEnhancer(new RequestEnhancer(){

            public void enhance(AccessTokenRequest request, OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form, HttpHeaders headers) {
                headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            }
        });
        template.setAccessTokenProvider((AccessTokenProvider)accessTokenProvider);
        return template;
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public OAuth2ClientContext oauth2ClientContext() {
        return new DefaultOAuth2ClientContext(this.accessTokenRequest);
    }
}

