/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.proxy;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.security.oauth2.proxy.ProxyAuthenticationProperties;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;

public class OAuth2TokenRelayFilter
extends ZuulFilter {
    private static final String ACCESS_TOKEN = "ACCESS_TOKEN";
    private Map<String, ProxyAuthenticationProperties.Route> routes = new HashMap<String, ProxyAuthenticationProperties.Route>();

    public OAuth2TokenRelayFilter(ProxyAuthenticationProperties properties) {
        this.routes = properties.getRoutes();
    }

    public int filterOrder() {
        return 10;
    }

    public String filterType() {
        return "pre";
    }

    public boolean shouldFilter() {
        Object details;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof OAuth2Authentication && (details = auth.getDetails()) instanceof OAuth2AuthenticationDetails) {
            String id;
            OAuth2AuthenticationDetails oauth = (OAuth2AuthenticationDetails)details;
            RequestContext ctx = RequestContext.getCurrentContext();
            if (ctx.containsKey((Object)"proxy") && this.routes.containsKey(id = (String)ctx.get((Object)"proxy")) && !ProxyAuthenticationProperties.Route.Scheme.OAUTH2.matches(this.routes.get(id).getScheme())) {
                return false;
            }
            ctx.set(ACCESS_TOKEN, (Object)oauth.getTokenValue());
            return true;
        }
        return false;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        ctx.addZuulRequestHeader("authorization", "Bearer " + ctx.get((Object)ACCESS_TOKEN));
        return null;
    }
}

