/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.sso;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.security.oauth2.resource.ResourceServerTokenServicesConfiguration;
import org.springframework.cloud.security.oauth2.sso.OAuth2SsoConfigurer;
import org.springframework.cloud.security.oauth2.sso.OAuth2SsoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnExpression(value="'${spring.oauth2.client.clientId:}'!=''")
@ConditionalOnClass(value={ResourceServerTokenServices.class, SecurityProperties.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties
@Import(value={ResourceServerTokenServicesConfiguration.class})
public class OAuth2SsoConfiguration
extends WebSecurityConfigurerAdapter
implements Ordered {
    @Autowired
    private OAuth2SsoProperties sso;
    @Autowired
    private ResourceServerTokenServices tokenServices;
    @Autowired
    @Qualifier(value="userInfoRestTemplate")
    private OAuth2RestOperations restTemplate;
    private List<OAuth2SsoConfigurer> configurers = Collections.emptyList();

    public int getOrder() {
        if (this.sso.getFilterOrder() != null) {
            return this.sso.getFilterOrder();
        }
        if (ClassUtils.isPresent((String)"org.springframework.boot.actuate.autoconfigure.ManagementServerProperties", null)) {
            return 0x7FFFFFF6;
        }
        return 0x7FFFFFF8;
    }

    @Autowired(required=false)
    public void setConfigurers(List<OAuth2SsoConfigurer> configurers) {
        this.configurers = new ArrayList<OAuth2SsoConfigurer>(configurers);
        AnnotationAwareOrderComparator.sort(this.configurers);
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.apply((SecurityConfigurerAdapter)new OAuth2ClientAuthenticationConfigurer(this.oauth2SsoFilter()));
        OAuth2SsoConfigurer.RequestMatchers matchers = new OAuth2SsoConfigurer.RequestMatchers();
        if (this.configurers.isEmpty()) {
            matchers.anyRequest();
        } else {
            matchers.antMatchers(new String[]{this.sso.getLoginPath()});
            for (OAuth2SsoConfigurer configurer : this.configurers) {
                configurer.match(matchers);
            }
        }
        http.requestMatchers().requestMatchers(matchers.getRequestMatchers());
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests = http.authorizeRequests();
        if (!this.sso.getHome().isSecure()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers(this.sso.getHome().getPath())).permitAll();
        }
        LogoutConfigurer logout = http.logout();
        logout.logoutSuccessUrl(this.sso.getHome().getRoot()).logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher(this.sso.getLogoutPath())).permitAll(!this.sso.getHome().isSecure());
        this.addRedirectToLogout((LogoutConfigurer<HttpSecurity>)logout);
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(this.sso.getLoginPath()));
        for (OAuth2SsoConfigurer configurer : this.configurers) {
            configurer.configure(http);
        }
        if (this.configurers.isEmpty()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated();
        }
    }

    private void addRedirectToLogout(LogoutConfigurer<HttpSecurity> logout) {
        if (this.sso.isLogoutRedirect()) {
            logout.addLogoutHandler(this.logoutHandler());
        }
    }

    protected OAuth2ClientAuthenticationProcessingFilter oauth2SsoFilter() {
        OAuth2ClientAuthenticationProcessingFilter filter = new OAuth2ClientAuthenticationProcessingFilter(this.sso.getLoginPath());
        filter.setRestTemplate(this.restTemplate);
        filter.setTokenServices(this.tokenServices);
        return filter;
    }

    private LogoutHandler logoutHandler() {
        LogoutHandler handler = new LogoutHandler(){

            public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
                OAuth2SsoConfiguration.this.restTemplate.getOAuth2ClientContext().setAccessToken(null);
                String redirect = request.getRequestURL().toString().replace(OAuth2SsoConfiguration.this.sso.getLogoutPath(), OAuth2SsoConfiguration.this.sso.getHome().getRoot());
                try {
                    response.sendRedirect(OAuth2SsoConfiguration.this.sso.getLogoutUri(redirect));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot logout remote server", e);
                }
            }
        };
        return handler;
    }

    @Configuration
    protected static class ConfigurationProperties {
        @Autowired
        private AuthorizationCodeResourceDetails client;

        protected ConfigurationProperties() {
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2SsoProperties ssoProperties() {
            return new OAuth2SsoProperties(this.client.getAccessTokenUri());
        }
    }

    public static final class OAuth2ClientAuthenticationConfigurer
    extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
        private OAuth2ClientAuthenticationProcessingFilter filter;

        public OAuth2ClientAuthenticationConfigurer(OAuth2ClientAuthenticationProcessingFilter filter) {
            this.filter = filter;
        }

        public void configure(HttpSecurity builder) throws Exception {
            OAuth2ClientAuthenticationProcessingFilter ssoFilter = this.filter;
            ssoFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)builder.getSharedObject(SessionAuthenticationStrategy.class));
            builder.addFilterAfter((Filter)ssoFilter, AbstractPreAuthenticatedProcessingFilter.class);
        }
    }
}

