/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper;

import org.springframework.cloud.skipper.SkipperException;

public class ReleaseNotFoundException
extends SkipperException {
    private final String releaseName;
    private final Integer releaseVersion;

    public ReleaseNotFoundException(String releaseName) {
        super(ReleaseNotFoundException.getExceptionMessage(releaseName));
        this.releaseName = releaseName;
        this.releaseVersion = null;
    }

    public ReleaseNotFoundException(String releaseName, int version) {
        super(ReleaseNotFoundException.getExceptionMessage(releaseName, version));
        this.releaseName = releaseName;
        this.releaseVersion = version;
    }

    public ReleaseNotFoundException(String releaseName, Throwable cause) {
        super(ReleaseNotFoundException.getExceptionMessage(releaseName), cause);
        this.releaseName = releaseName;
        this.releaseVersion = null;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public Integer getReleaseVersion() {
        return this.releaseVersion;
    }

    private static String getExceptionMessage(String releaseName) {
        return String.format("Release with the name [%s] doesn't exist", releaseName);
    }

    private static String getExceptionMessage(String releaseName, int version) {
        return String.format("Release with the name [%s] and version [%s] doesn't exist", releaseName, version);
    }
}

