/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.skipper.SkipperException;
import org.springframework.cloud.skipper.domain.SkipperManifestKind;
import org.springframework.cloud.skipper.domain.SkipperManifestReader;
import org.springframework.cloud.skipper.domain.SpringCloudDeployerApplicationManifest;
import org.yaml.snakeyaml.Yaml;

public class SpringCloudDeployerApplicationManifestReader
implements SkipperManifestReader {
    private static final Logger logger = LoggerFactory.getLogger(SpringCloudDeployerApplicationManifestReader.class);

    @Override
    public List<SpringCloudDeployerApplicationManifest> read(String manifest) {
        if (this.canSupport(manifest)) {
            ArrayList<SpringCloudDeployerApplicationManifest> applicationSpecs = new ArrayList<SpringCloudDeployerApplicationManifest>();
            YAMLMapper mapper = new YAMLMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                MappingIterator it = mapper.readerFor(SpringCloudDeployerApplicationManifest.class).readValues(manifest);
                while (it.hasNextValue()) {
                    SpringCloudDeployerApplicationManifest appKind = (SpringCloudDeployerApplicationManifest)it.next();
                    applicationSpecs.add(appKind);
                }
            }
            catch (JsonMappingException e) {
                logger.error("Can't parse Package's manifest YAML = " + manifest);
                throw new SkipperException("JsonMappingException - Can't parse Package's manifest YAML = " + manifest, e);
            }
            catch (RuntimeJsonMappingException e) {
                logger.error("Can't parse Package's manifest YAML = " + manifest);
                throw new SkipperException("JsonMappingException - Can't parse Package's manifest YAML = " + manifest, e);
            }
            catch (IOException e) {
                logger.error("Can't parse Package's manifest YAML = " + manifest);
                throw new SkipperException("IOException - Can't parse Package's manifest YAML = " + manifest, e);
            }
            return applicationSpecs;
        }
        return Collections.emptyList();
    }

    public boolean canSupport(String manifest) {
        Yaml yaml = new Yaml();
        Iterable object = yaml.loadAll(manifest);
        for (Object o : object) {
            boolean supportKind = this.assertSupportedKind(o);
            if (supportKind) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] getSupportedKinds() {
        return new String[]{SkipperManifestKind.SpringBootApp.name(), SkipperManifestKind.SpringCloudDeployerApplication.name()};
    }

    private boolean assertSupportedKind(Object object) {
        if (object == null) {
            throw new SkipperException("Can't parse manifest, it is empty");
        }
        if (!(object instanceof Map)) {
            throw new SkipperException("Can't parse manifest, it is not a map.  Manifest = " + object);
        }
        Map manifestAsMap = (Map)object;
        Object kindObject = manifestAsMap.get("kind");
        if (kindObject instanceof String) {
            String kind = (String)kindObject;
            if (Arrays.asList(this.getSupportedKinds()).contains(kind)) {
                logger.debug("Found supported kind " + kind);
                return true;
            }
        }
        return false;
    }
}

