/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.web;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SingleSkipPattern;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.ConditionalOnSleuthWeb;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSleuthWeb
@EnableConfigurationProperties(value={SleuthWebProperties.class})
class SkipPatternConfiguration {
    private static final Log log = LogFactory.getLog(SkipPatternConfiguration.class);

    SkipPatternConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    SkipPatternProvider sleuthSkipPatternProvider(@Nullable List<SingleSkipPattern> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return null;
        }
        try {
            Pattern result = SkipPatternConfiguration.consolidateSkipPatterns(patterns);
            if (result == null) {
                return null;
            }
            return () -> result;
        }
        catch (BeanCreationException e) {
            log.warn((Object)"Most likely, there is an actuator endpoint that indirectly references an instrumented HTTP client. An exception was thrown during bean initialization. Will ignore that exception", (Throwable)e);
            return () -> SkipPatternConfiguration.consolidateSkipPatterns(patterns);
        }
    }

    @Nullable
    static Pattern consolidateSkipPatterns(List<SingleSkipPattern> patterns) {
        List presentPatterns = patterns.stream().map(SingleSkipPattern::skipPattern).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (presentPatterns.isEmpty()) {
            return null;
        }
        if (presentPatterns.size() == 1) {
            return (Pattern)presentPatterns.get(0);
        }
        StringJoiner joiner = new StringJoiner("|");
        for (Pattern pattern : presentPatterns) {
            String s = pattern.pattern();
            joiner.add(s);
        }
        return Pattern.compile(joiner.toString());
    }

    @Configuration(proxyBeanMethods=false)
    static class DefaultSkipPatternConfig {
        DefaultSkipPatternConfig() {
        }

        @Bean
        SingleSkipPattern defaultSkipPatternBean(Environment environment, SleuthWebProperties sleuthWebProperties) {
            String skipPattern = sleuthWebProperties.getSkipPattern();
            String left = StringUtils.hasText((String)skipPattern) ? environment.resolvePlaceholders(skipPattern) : skipPattern;
            String additionalSkipPattern = sleuthWebProperties.getAdditionalSkipPattern();
            String right = StringUtils.hasText((String)additionalSkipPattern) ? environment.resolvePlaceholders(additionalSkipPattern) : additionalSkipPattern;
            Pattern pattern = DefaultSkipPatternConfig.combinePatterns(left, right);
            return () -> Optional.ofNullable(pattern);
        }

        private static Pattern combinePatterns(String left, String right) {
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                return Pattern.compile(right);
            }
            if (right == null) {
                return Pattern.compile(left);
            }
            return Pattern.compile(left + "|" + right);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ServerProperties.class, EndpointsSupplier.class, ExposableWebEndpoint.class})
    @ConditionalOnBean(value={ServerProperties.class})
    @ConditionalOnProperty(value={"spring.sleuth.web.ignore-auto-configured-skip-patterns"}, havingValue="false", matchIfMissing=true)
    protected static class ActuatorSkipPatternProviderConfig {
        protected ActuatorSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getEndpointsPatterns(Environment environment, String contextPath, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            Collection endpoints = endpointsSupplier.getEndpoints();
            if (endpoints.isEmpty()) {
                return Optional.empty();
            }
            String basePath = webEndpointProperties.getBasePath();
            String pattern = ActuatorSkipPatternProviderConfig.patternFromEndpoints(contextPath, endpoints, basePath);
            if (StringUtils.hasText((String)pattern)) {
                return Optional.of(Pattern.compile(environment.resolvePlaceholders(pattern)));
            }
            return Optional.empty();
        }

        private static String patternFromEndpoints(String contextPath, Collection<ExposableWebEndpoint> endpoints, String basePath) {
            StringJoiner joiner = new StringJoiner("|", ActuatorSkipPatternProviderConfig.getPathPrefix(contextPath, basePath), ActuatorSkipPatternProviderConfig.getPathSuffix(contextPath, basePath));
            for (ExposableWebEndpoint endpoint : endpoints) {
                String path = endpoint.getRootPath();
                String paths = path + "|" + path + "/.*";
                joiner.add(paths);
            }
            return joiner.toString();
        }

        private static String getPathPrefix(String contextPath, String actuatorBasePath) {
            String result = "";
            if (StringUtils.hasText((String)contextPath)) {
                result = result + contextPath;
            }
            if (!actuatorBasePath.equals("/")) {
                result = result + actuatorBasePath;
            }
            boolean ignoreBase = StringUtils.hasText((String)result) && !result.equals("/");
            String suffix = "/(";
            if (ignoreBase) {
                suffix = "(/|" + suffix;
            }
            return result + suffix;
        }

        private static String getPathSuffix(String contextPath, String actuatorBasePath) {
            String result = ")";
            if (StringUtils.hasText((String)contextPath) || StringUtils.hasText((String)actuatorBasePath) && !"/".equals(actuatorBasePath)) {
                result = result + ")?";
            }
            return result;
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.SAME)
        @ConditionalOnBean(value={WebEndpointProperties.class})
        SingleSkipPattern skipPatternForActuatorEndpointsSamePort(Environment environment, ServerProperties serverProperties, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            return () -> ActuatorSkipPatternProviderConfig.getEndpointsPatterns(environment, serverProperties.getServlet().getContextPath(), webEndpointProperties, endpointsSupplier);
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @ConditionalOnProperty(name={"management.server.servlet.context-path"}, havingValue="/", matchIfMissing=true)
        @ConditionalOnBean(value={WebEndpointProperties.class})
        SingleSkipPattern skipPatternForActuatorEndpointsDifferentPort(Environment environment, WebEndpointProperties webEndpointProperties, ObjectProvider<ManagementServerProperties> managementServerProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            return () -> {
                ManagementServerProperties props = (ManagementServerProperties)managementServerProperties.getIfAvailable();
                return ActuatorSkipPatternProviderConfig.getEndpointsPatterns(environment, props != null ? props.getBasePath() : null, webEndpointProperties, endpointsSupplier);
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ManagementServerProperties.class})
    @ConditionalOnProperty(value={"spring.sleuth.web.ignore-auto-configured-skip-patterns"}, havingValue="false", matchIfMissing=true)
    protected static class ManagementSkipPatternProviderConfig {
        protected ManagementSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getPatternForManagementServerProperties(Environment environment, ManagementServerProperties managementServerProperties) {
            String contextPath = managementServerProperties.getBasePath();
            if (StringUtils.hasText((String)contextPath)) {
                return Optional.of(Pattern.compile(environment.resolvePlaceholders(contextPath) + ".*"));
            }
            return Optional.empty();
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        SingleSkipPattern skipPatternForManagementServerProperties(Environment environment, ManagementServerProperties managementServerProperties) {
            return () -> ManagementSkipPatternProviderConfig.getPatternForManagementServerProperties(environment, managementServerProperties);
        }
    }
}

