/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.kafka;

import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.kafka.TracingKafkaConsumerBeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.kafka.TracingKafkaProducerBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.kafka.TracingKafkaPropagatorGetter;
import org.springframework.cloud.sleuth.instrument.kafka.TracingKafkaPropagatorSetter;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={KafkaClient.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.kafka.enabled"}, matchIfMissing=true)
public class TracingKafkaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ProducerRecord.class}, parameterizedContainer={Propagator.Setter.class})
    Propagator.Setter<ProducerRecord<?, ?>> tracingKafkaPropagationSetter() {
        return new TracingKafkaPropagatorSetter();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConsumerRecord.class}, parameterizedContainer={Propagator.Getter.class})
    Propagator.Getter<ConsumerRecord<?, ?>> tracingKafkaPropagationGetter() {
        return new TracingKafkaPropagatorGetter();
    }

    @Bean
    static TracingKafkaProducerBeanPostProcessor tracingKafkaProducerBeanPostProcessor(BeanFactory beanFactory) {
        return new TracingKafkaProducerBeanPostProcessor(beanFactory);
    }

    @Bean
    static TracingKafkaConsumerBeanPostProcessor tracingKafkaConsumerBeanPostProcessor(BeanFactory beanFactory) {
        return new TracingKafkaConsumerBeanPostProcessor(beanFactory);
    }
}

