/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.messaging;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.function.context.catalog.FunctionAroundWrapper;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.FunctionMessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.TraceFunctionAroundWrapper;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.function.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={FunctionAroundWrapper.class, RefreshScopeRefreshedEvent.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceFunctionAutoConfiguration {
    @Bean
    TraceFunctionAroundWrapper traceFunctionAroundWrapper(Environment environment, Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> injector, Propagator.Getter<MessageHeaderAccessor> extractor, ObjectProvider<List<FunctionMessageSpanCustomizer>> customizers) {
        return new TraceFunctionAroundWrapper(environment, tracer, propagator, injector, extractor, (List)customizers.getIfAvailable(ArrayList::new));
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DirectWithAttributesChannel.class})
    static class TraceFunctionStreamConfiguration {
        TraceFunctionStreamConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(name={"org.springframework.cloud.stream.binder.rabbit.properties.RabbitBinderConfigurationProperties"})
        @ConditionalOnMissingClass(value={"org.springframework.cloud.stream.binder.kafka.config.KafkaBinderConfiguration"})
        static class RabbitOnlyStreamConfiguration {
            RabbitOnlyStreamConfiguration() {
            }

            @Bean
            FunctionMessageSpanCustomizer traceRabbitFunctionMessageSpanCustomizer() {
                return new FunctionMessageSpanCustomizer(){

                    public void customizeInputMessageSpan(Span span, Message<?> message) {
                        span.remoteServiceName("rabbitmq");
                    }

                    public void customizeOutputMessageSpan(Span span, Message<?> message) {
                        span.remoteServiceName("rabbitmq");
                    }
                };
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(name={"org.springframework.cloud.stream.binder.kafka.config.KafkaBinderConfiguration"})
        @ConditionalOnMissingClass(value={"org.springframework.cloud.stream.binder.rabbit.properties.RabbitBinderConfigurationProperties"})
        static class KafkaOnlyStreamConfiguration {
            KafkaOnlyStreamConfiguration() {
            }

            @Bean
            FunctionMessageSpanCustomizer traceKafkaFunctionMessageSpanCustomizer() {
                return new FunctionMessageSpanCustomizer(){

                    public void customizeInputMessageSpan(Span span, Message<?> message) {
                        span.remoteServiceName("kafka");
                    }

                    public void customizeOutputMessageSpan(Span span, Message<?> message) {
                        span.remoteServiceName("kafka");
                    }
                };
            }
        }
    }
}

