/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.messaging;

import java.util.function.Function;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.SleuthIntegrationMessagingProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.SleuthMessagingProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.TraceSpringMessagingAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.TracingChannelInterceptorCondition;
import org.springframework.cloud.sleuth.instrument.messaging.DefaultMessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.TracingChannelInterceptor;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.channel.interceptor.GlobalChannelInterceptorWrapper;
import org.springframework.integration.config.GlobalChannelInterceptor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ImmutableMessageChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={GlobalChannelInterceptor.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class, TraceSpringMessagingAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.messaging.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SleuthIntegrationMessagingProperties.class})
@Conditional(value={TracingChannelInterceptorCondition.class})
public class TraceSpringIntegrationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MessageSpanCustomizer defaultMessageSpanCustomizer() {
        return new DefaultMessageSpanCustomizer();
    }

    @Bean
    GlobalChannelInterceptorWrapper traceGlobalChannelInterceptorWrapper(TracingChannelInterceptor interceptor, SleuthIntegrationMessagingProperties properties) {
        GlobalChannelInterceptorWrapper wrapper = new GlobalChannelInterceptorWrapper((ChannelInterceptor)interceptor);
        wrapper.setPatterns(properties.getPatterns());
        return wrapper;
    }

    @Bean
    TracingChannelInterceptor traceChannelInterceptor(Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> traceMessagePropagationSetter, Propagator.Getter<MessageHeaderAccessor> traceMessagePropagationGetter, SleuthMessagingProperties properties, MessageSpanCustomizer messageSpanCustomizer) {
        return new TracingChannelInterceptor(tracer, propagator, traceMessagePropagationSetter, traceMessagePropagationGetter, TraceSpringIntegrationAutoConfiguration.remoteServiceNameMapper(properties), messageSpanCustomizer);
    }

    @Bean
    GlobalChannelInterceptorWrapper afterSleuthImmutableMessageChannelInterceptor(SleuthIntegrationMessagingProperties properties) {
        GlobalChannelInterceptorWrapper interceptor = new GlobalChannelInterceptorWrapper((ChannelInterceptor)new ImmutableMessageChannelInterceptor());
        interceptor.setOrder(Integer.MAX_VALUE);
        interceptor.setPatterns(properties.getPatterns());
        return interceptor;
    }

    static Function<String, String> remoteServiceNameMapper(SleuthMessagingProperties properties) {
        return s -> {
            if (!StringUtils.hasText((String)s)) {
                return null;
            }
            if (s.startsWith("amqp") || s.startsWith("rabbit")) {
                return properties.getRabbit().getRemoteServiceName();
            }
            if (s.startsWith("kafka")) {
                return properties.getKafka().getRemoteServiceName();
            }
            return null;
        };
    }
}

