/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.reactor.netty;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import org.springframework.cloud.sleuth.brave.instrument.reactor.netty.TracingHandlerUtil;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientRequest;

public class TracingChannelOutboundHandler
extends ChannelOutboundHandlerAdapter {
    static final AttributeKey<Span> SPAN_ATTRIBUTE_KEY = AttributeKey.valueOf((String)Span.class.getName());
    final CurrentTraceContext currentTraceContext;

    public TracingChannelOutboundHandler(CurrentTraceContext currentTraceContext) {
        this.currentTraceContext = currentTraceContext;
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        if (this.instrumentOperation(ctx, () -> ctx.bind(localAddress, promise))) {
            return;
        }
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        if (this.instrumentOperation(ctx, () -> ctx.connect(remoteAddress, localAddress, promise))) {
            return;
        }
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.instrumentOperation(ctx, () -> ctx.disconnect(promise))) {
            return;
        }
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.instrumentOperation(ctx, () -> ctx.close(promise))) {
            return;
        }
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.instrumentOperation(ctx, () -> ctx.deregister(promise))) {
            return;
        }
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) {
        if (this.instrumentOperation(ctx, () -> ctx.read())) {
            return;
        }
        ctx.read();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.instrumentOperation(ctx, () -> ctx.write(msg, promise))) {
            return;
        }
        ctx.write(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) {
        if (this.instrumentOperation(ctx, () -> ctx.flush())) {
            return;
        }
        ctx.flush();
    }

    public boolean isSharable() {
        return false;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.instrumentOperation(ctx, () -> {
            try {
                super.handlerAdded(ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })) {
            return;
        }
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.instrumentOperation(ctx, () -> {
            try {
                super.handlerRemoved(ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })) {
            return;
        }
        super.handlerRemoved(ctx);
    }

    boolean instrumentOperation(ChannelHandlerContext ctx, Runnable operation) {
        Span span = (Span)ctx.channel().attr(SPAN_ATTRIBUTE_KEY).get();
        if (span != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());){
                operation.run();
            }
            return true;
        }
        Connection conn = Connection.from((Channel)ctx.channel());
        if (conn instanceof ConnectionObserver) {
            TraceContext parent = (TraceContext)((ConnectionObserver)conn).currentContext().getOrDefault(TraceContext.class, null);
            if (parent != null) {
                try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(parent);){
                    operation.run();
                }
                return true;
            }
        } else {
            TraceContext traceContext;
            ChannelOperations ops = (ChannelOperations)conn.as(ChannelOperations.class);
            if (ops instanceof HttpClientRequest && (traceContext = TracingHandlerUtil.traceContext(((HttpClientRequest)ops).currentContextView())) != null) {
                try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(traceContext);){
                    operation.run();
                }
                return true;
            }
        }
        return false;
    }
}

