/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.mvc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

final class TraceContextListenableFuture<T>
implements ListenableFuture<T> {
    final ListenableFuture<T> delegate;
    final CurrentTraceContext currentTraceContext;
    final TraceContext invocationContext;

    TraceContextListenableFuture(ListenableFuture<T> delegate, CurrentTraceContext currentTraceContext, TraceContext invocationContext) {
        this.delegate = delegate;
        this.currentTraceContext = currentTraceContext;
        this.invocationContext = invocationContext;
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.delegate.addCallback((ListenableFutureCallback)(callback != null ? new TraceContextListenableFutureCallback<T>(callback, this) : null));
    }

    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.delegate.addCallback(successCallback != null ? new TraceContextSuccessCallback<T>(successCallback, this) : null, (FailureCallback)(failureCallback != null ? new TraceContextFailureCallback(failureCallback, this) : null));
    }

    public CompletableFuture<T> completable() {
        return this.delegate.completable();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    static final class TraceContextFailureCallback
    implements FailureCallback {
        final FailureCallback delegate;
        final CurrentTraceContext currentTraceContext;
        final TraceContext invocationContext;

        TraceContextFailureCallback(FailureCallback delegate, TraceContextListenableFuture<?> future) {
            this.delegate = delegate;
            this.currentTraceContext = future.currentTraceContext;
            this.invocationContext = future.invocationContext;
        }

        public void onFailure(Throwable ex) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
                this.delegate.onFailure(ex);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static final class TraceContextSuccessCallback<T>
    implements SuccessCallback<T> {
        final SuccessCallback<T> delegate;
        final CurrentTraceContext currentTraceContext;
        final TraceContext invocationContext;

        TraceContextSuccessCallback(SuccessCallback<T> delegate, TraceContextListenableFuture<?> future) {
            this.delegate = delegate;
            this.currentTraceContext = future.currentTraceContext;
            this.invocationContext = future.invocationContext;
        }

        public void onSuccess(T result) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
                this.delegate.onSuccess(result);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static final class TraceContextListenableFutureCallback<T>
    implements ListenableFutureCallback<T> {
        final ListenableFutureCallback<T> delegate;
        final CurrentTraceContext currentTraceContext;
        final TraceContext invocationContext;

        TraceContextListenableFutureCallback(ListenableFutureCallback<T> delegate, TraceContextListenableFuture<?> future) {
            this.delegate = delegate;
            this.currentTraceContext = future.currentTraceContext;
            this.invocationContext = future.invocationContext;
        }

        public void onSuccess(T result) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
                this.delegate.onSuccess(result);
            }
        }

        public void onFailure(Throwable ex) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
                this.delegate.onFailure(ex);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

