/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.mongodb;

import com.mongodb.RequestContext;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoSpanCustomizer;
import org.springframework.lang.Nullable;

final class TraceMongoCommandListener
implements CommandListener {
    private static final Log log = LogFactory.getLog(TraceMongoCommandListener.class);
    static final Set<String> COMMANDS_WITH_COLLECTION_NAME = new LinkedHashSet<String>(Arrays.asList("aggregate", "count", "distinct", "mapReduce", "geoSearch", "delete", "find", "findAndModify", "insert", "update", "collMod", "compact", "convertToCapped", "create", "createIndexes", "drop", "dropIndexes", "killCursors", "listIndexes", "reIndex"));
    private final Tracer tracer;
    private final CurrentTraceContext currentTraceContext;
    private final List<TraceMongoSpanCustomizer> customizers;

    TraceMongoCommandListener(Tracer tracer, List<TraceMongoSpanCustomizer> customizers) {
        this.tracer = tracer;
        this.currentTraceContext = tracer.currentTraceContext();
        this.customizers = customizers;
    }

    public void commandStarted(CommandStartedEvent event) {
        String databaseName;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Instrumenting the command started event");
        }
        if ("admin".equals(databaseName = event.getDatabaseName())) {
            return;
        }
        RequestContext requestContext = event.getRequestContext();
        if (requestContext == null) {
            return;
        }
        Span parent = TraceMongoCommandListener.spanFromContext(this.tracer, this.currentTraceContext, requestContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found the following span passed from the mongo context [" + parent + "]"));
        }
        if (parent == null) {
            return;
        }
        Span.Builder childSpanBuilder = this.tracer.spanBuilder();
        childSpanBuilder.setParent(parent.context());
        String commandName = event.getCommandName();
        BsonDocument command = event.getCommand();
        String collectionName = this.getCollectionName(command, commandName);
        childSpanBuilder.name(TraceMongoCommandListener.getSpanName(commandName, collectionName)).kind(Span.Kind.CLIENT).remoteServiceName("mongodb-" + databaseName).tag("mongodb.command", commandName);
        if (collectionName != null) {
            childSpanBuilder.tag("mongodb.collection", collectionName);
        }
        this.customizers.forEach(customizer -> customizer.customizeCommandStartSpan(event, childSpanBuilder));
        Span childSpan = childSpanBuilder.start();
        requestContext.put(Span.class, (Object)childSpan);
        requestContext.put(TraceContext.class, (Object)childSpan.context());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a child span  [" + childSpan + "] for mongo instrumentation and put it in Reactor context"));
        }
    }

    private static Span spanFromContext(Tracer tracer, CurrentTraceContext currentTraceContext, RequestContext context) {
        Span span = (Span)context.getOrDefault(Span.class, null);
        if (span != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a span in mongo context [" + span + "]"));
            }
            return span;
        }
        TraceContext traceContext = (TraceContext)context.getOrDefault(TraceContext.class, null);
        if (traceContext != null) {
            try (CurrentTraceContext.Scope scope = currentTraceContext.maybeScope(traceContext);){
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found a trace context in mongo context [" + traceContext + "]"));
                }
                Span span2 = tracer.currentSpan();
                return span2;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No span was found - will not create any child spans");
        }
        return null;
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        RequestContext requestContext = event.getRequestContext();
        if (requestContext == null) {
            return;
        }
        Span span = (Span)requestContext.getOrDefault(Span.class, null);
        if (span == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Command succeeded - will close span [" + span + "]"));
        }
        span.end();
        requestContext.delete(Span.class);
        requestContext.delete(TraceContext.class);
    }

    public void commandFailed(CommandFailedEvent event) {
        RequestContext requestContext = event.getRequestContext();
        if (requestContext == null) {
            return;
        }
        Span span = (Span)requestContext.getOrDefault(Span.class, null);
        if (span == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Command failed - will close span [" + span + "]"));
        }
        span.error(event.getThrowable());
        span.end();
        requestContext.delete(Span.class);
        requestContext.delete(TraceContext.class);
    }

    @Nullable
    String getCollectionName(BsonDocument command, String commandName) {
        String collectionName;
        if (COMMANDS_WITH_COLLECTION_NAME.contains(commandName) && (collectionName = TraceMongoCommandListener.getNonEmptyBsonString(command.get((Object)commandName))) != null) {
            return collectionName;
        }
        return TraceMongoCommandListener.getNonEmptyBsonString(command.get((Object)"collection"));
    }

    @Nullable
    static String getNonEmptyBsonString(BsonValue bsonValue) {
        if (bsonValue == null || !bsonValue.isString()) {
            return null;
        }
        String stringValue = bsonValue.asString().getValue().trim();
        return stringValue.isEmpty() ? null : stringValue;
    }

    static String getSpanName(String commandName, @Nullable String collectionName) {
        if (collectionName == null) {
            return commandName;
        }
        return commandName + " " + collectionName;
    }
}

