/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import org.springframework.util.StringUtils;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;

public class ZipkinSpanListener
implements SpanReporter {
    private static final List<String> ZIPKIN_START_EVENTS = Arrays.asList("cr", "sr");
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ZipkinSpanListener.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] UNKNOWN_BYTES = "unknown".getBytes(UTF_8);
    private ZipkinSpanReporter reporter;
    EndpointLocator endpointLocator;

    public ZipkinSpanListener(ZipkinSpanReporter reporter, EndpointLocator endpointLocator) {
        this.reporter = reporter;
        this.endpointLocator = endpointLocator;
    }

    zipkin.Span convert(Span span) {
        Span.Builder zipkinSpan = zipkin.Span.builder();
        if (this.notClientOrServer(span)) {
            this.ensureLocalComponent(span, zipkinSpan);
        }
        this.addZipkinAnnotations(zipkinSpan, span, this.endpointLocator.local());
        this.addZipkinBinaryAnnotations(zipkinSpan, span, this.endpointLocator.local());
        if (this.hasClientSend(span)) {
            this.ensureServerAddr(span, zipkinSpan);
        }
        zipkinSpan.timestamp(Long.valueOf(span.getBegin() * 1000L));
        zipkinSpan.duration(Long.valueOf(span.getAccumulatedMillis() * 1000L));
        zipkinSpan.traceId(span.getTraceId());
        if (span.getParents().size() > 0) {
            if (span.getParents().size() > 1) {
                log.error((Object)("Zipkin doesn't support spans with multiple parents. Omitting other parents for " + span));
            }
            zipkinSpan.parentId((Long)span.getParents().get(0));
        }
        zipkinSpan.id(span.getSpanId());
        if (StringUtils.hasText((String)span.getName())) {
            zipkinSpan.name(span.getName());
        }
        return zipkinSpan.build();
    }

    private void ensureLocalComponent(Span span, Span.Builder zipkinSpan) {
        if (span.tags().containsKey("lc")) {
            return;
        }
        byte[] processId = span.getProcessId() != null ? span.getProcessId().toLowerCase().getBytes(UTF_8) : UNKNOWN_BYTES;
        BinaryAnnotation component = BinaryAnnotation.builder().type(BinaryAnnotation.Type.STRING).key("lc").value(processId).endpoint(this.endpointLocator.local()).build();
        zipkinSpan.addBinaryAnnotation(component);
    }

    private void ensureServerAddr(Span span, Span.Builder zipkinSpan) {
        String serviceName = span.tags().containsKey("peer.service") ? (String)span.tags().get("peer.service") : this.endpointLocator.local().serviceName;
        zipkinSpan.addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)this.endpointLocator.local().toBuilder().serviceName(serviceName).build()));
    }

    private boolean notClientOrServer(Span span) {
        for (Log log : span.logs()) {
            if (!ZIPKIN_START_EVENTS.contains(log.getEvent())) continue;
            return false;
        }
        return true;
    }

    private boolean hasClientSend(Span span) {
        for (Log log : span.logs()) {
            if (!"cs".equals(log.getEvent())) continue;
            return !span.tags().containsKey("sa");
        }
        return false;
    }

    private void addZipkinAnnotations(Span.Builder zipkinSpan, Span span, Endpoint endpoint) {
        for (Log ta : span.logs()) {
            Annotation zipkinAnnotation = Annotation.builder().endpoint(endpoint).timestamp(ta.getTimestamp() * 1000L).value(ta.getEvent()).build();
            zipkinSpan.addAnnotation(zipkinAnnotation);
        }
    }

    private void addZipkinBinaryAnnotations(Span.Builder zipkinSpan, Span span, Endpoint ep) {
        for (Map.Entry e : span.tags().entrySet()) {
            BinaryAnnotation binaryAnn = BinaryAnnotation.builder().type(BinaryAnnotation.Type.STRING).key((String)e.getKey()).value(((String)e.getValue()).getBytes(UTF_8)).endpoint(ep).build();
            zipkinSpan.addBinaryAnnotation(binaryAnn);
        }
    }

    public void report(Span span) {
        if (span.isExportable()) {
            this.reporter.report(this.convert(span));
        }
    }
}

