/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import org.springframework.context.event.EventListener;
import zipkin.Endpoint;

public class ServerPropertiesEndpointLocator
implements EndpointLocator {
    private final ServerProperties serverProperties;
    private final String appName;
    private Integer port;

    public ServerPropertiesEndpointLocator(ServerProperties serverProperties, String appName) {
        this.serverProperties = serverProperties;
        this.appName = appName;
    }

    @Override
    public Endpoint local() {
        return Endpoint.builder().serviceName(this.appName).ipv4(this.getAddress()).port(this.getPort().intValue()).build();
    }

    @EventListener(value={EmbeddedServletContainerInitializedEvent.class})
    public void grabPort(EmbeddedServletContainerInitializedEvent event) {
        this.port = event.getEmbeddedServletContainer().getPort();
    }

    private Integer getPort() {
        if (this.port != null) {
            return this.port;
        }
        Integer port = this.serverProperties != null && this.serverProperties.getPort() != null ? this.serverProperties.getPort() : Integer.valueOf(8080);
        return port;
    }

    private int getAddress() {
        if (this.serverProperties != null && this.serverProperties.getAddress() != null) {
            return InetUtils.getIpAddressAsInt((String)this.serverProperties.getAddress().getHostAddress());
        }
        return 2130706433;
    }
}

