/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.springframework.cloud.sleuth.zipkin.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin.ZipkinRestTemplateCustomizer;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class DefaultZipkinRestTemplateCustomizer
implements ZipkinRestTemplateCustomizer {
    private final ZipkinProperties zipkinProperties;

    public DefaultZipkinRestTemplateCustomizer(ZipkinProperties zipkinProperties) {
        this.zipkinProperties = zipkinProperties;
    }

    @Override
    public void customize(RestTemplate restTemplate) {
        if (this.zipkinProperties.getCompression().isEnabled()) {
            restTemplate.getInterceptors().add(0, new GZipInterceptor());
        }
    }

    private class GZipInterceptor
    implements ClientHttpRequestInterceptor {
        private GZipInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            request.getHeaders().add("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            try (GZIPOutputStream compressor = new GZIPOutputStream(gzipped);){
                compressor.write(body);
            }
            return execution.execute(request, gzipped.toByteArray());
        }
    }
}

