/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.keyval;

import org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorCreationException;
import org.springframework.cloud.service.Util;
import org.springframework.cloud.service.common.RedisServiceInfo;
import org.springframework.cloud.service.keyval.RedisConnectionFactoryConfig;
import org.springframework.cloud.service.keyval.RedisJedisClientConfigurer;
import org.springframework.cloud.service.keyval.RedisLettuceClientConfigurer;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

public class RedisConnectionFactoryCreator
extends AbstractServiceConnectorCreator<RedisConnectionFactory, RedisServiceInfo> {
    private static final String JEDIS_CLASS_NAME = "redis.clients.jedis.Jedis";
    private static final String LETTUCE_CLASS_NAME = "io.lettuce.core.RedisClient";

    public RedisConnectionFactory create(RedisServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig) {
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration();
        configuration.setHostName(serviceInfo.getHost());
        configuration.setPort(serviceInfo.getPort());
        configuration.setPassword(RedisPassword.of((String)serviceInfo.getPassword()));
        if (Util.hasClass(JEDIS_CLASS_NAME)) {
            JedisClientConfiguration.JedisClientConfigurationBuilder builder = JedisClientConfiguration.builder();
            RedisJedisClientConfigurer clientConfigurer = new RedisJedisClientConfigurer();
            if (serviceConnectorConfig instanceof RedisConnectionFactoryConfig) {
                clientConfigurer.configure(builder, (RedisConnectionFactoryConfig)serviceConnectorConfig);
            } else {
                clientConfigurer.configure(builder, (PooledServiceConnectorConfig)serviceConnectorConfig);
            }
            JedisConnectionFactory connectionFactory = new JedisConnectionFactory(configuration, builder.build());
            connectionFactory.afterPropertiesSet();
            return connectionFactory;
        }
        if (Util.hasClass(LETTUCE_CLASS_NAME)) {
            LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder();
            RedisLettuceClientConfigurer clientConfigurer = new RedisLettuceClientConfigurer();
            if (serviceConnectorConfig instanceof RedisConnectionFactoryConfig) {
                clientConfigurer.configure(builder, (RedisConnectionFactoryConfig)serviceConnectorConfig);
            } else {
                clientConfigurer.configure(builder, (PooledServiceConnectorConfig)serviceConnectorConfig);
            }
            LettuceConnectionFactory connectionFactory = new LettuceConnectionFactory(configuration, (LettuceClientConfiguration)builder.build());
            connectionFactory.afterPropertiesSet();
            return connectionFactory;
        }
        throw new ServiceConnectorCreationException(String.format("Failed to create cloud Redis connection factory for %s service. No client implementation classes  of jedis or lettuce clients implementation (%s, %s) not found", serviceInfo.getId(), JEDIS_CLASS_NAME, LETTUCE_CLASS_NAME));
    }
}

