/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.keyval;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.cloud.service.MapServiceConnectionConfigurer;
import org.springframework.cloud.service.MapServiceConnectorConfig;
import org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorConfigurer;
import org.springframework.cloud.service.Util;
import org.springframework.cloud.service.keyval.RedisConnectionFactoryConfig;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

public class RedisLettuceClientConfigurer
implements ServiceConnectorConfigurer<LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder, RedisConnectionFactoryConfig> {
    private MapServiceConnectionConfigurer<LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder, MapServiceConnectorConfig> mapClientConfigurer = new MapServiceConnectionConfigurer();

    public LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder configure(LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder clientConfiguration, RedisConnectionFactoryConfig config) {
        if (config != null) {
            this.configurePool(clientConfiguration, config);
            this.configureClient(clientConfiguration, config);
        }
        return clientConfiguration;
    }

    public LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder configure(LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder clientConfiguration, PooledServiceConnectorConfig config) {
        if (config != null) {
            this.configurePool(clientConfiguration, config);
        }
        return clientConfiguration;
    }

    private void configurePool(LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder clientConfiguration, PooledServiceConnectorConfig config) {
        if (config.getPoolConfig() != null) {
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            BeanWrapperImpl target = new BeanWrapperImpl((Object)poolConfig);
            BeanWrapperImpl source = new BeanWrapperImpl((Object)config.getPoolConfig());
            Util.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)source);
            clientConfiguration.poolConfig(poolConfig);
        }
    }

    private void configureClient(LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder clientConfiguration, RedisConnectionFactoryConfig config) {
        if (config.getConnectionProperties() != null) {
            this.mapClientConfigurer.configure(clientConfiguration, config.getConnectionProperties());
        }
    }
}

