/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamBinder;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderUtils;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsDlqDispatch;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsMessageConversionDelegate;
import org.springframework.cloud.stream.binder.kafka.streams.KeyValueSerdeResolver;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@Import(value={KafkaAutoConfiguration.class, KStreamMissingBeansRegistrar.class})
public class KStreamBinderConfiguration {
    @Bean
    public KafkaTopicProvisioner provisioningProvider(KafkaBinderConfigurationProperties binderConfigurationProperties, KafkaProperties kafkaProperties) {
        return new KafkaTopicProvisioner(binderConfigurationProperties, kafkaProperties);
    }

    @Bean
    public KStreamBinder kStreamBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsMessageConversionDelegate KafkaStreamsMessageConversionDelegate2, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, KeyValueSerdeResolver keyValueSerdeResolver, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, @Qualifier(value="kafkaStreamsDlqDispatchers") Map<String, KafkaStreamsDlqDispatch> kafkaStreamsDlqDispatchers) {
        KStreamBinder kStreamBinder = new KStreamBinder(binderConfigurationProperties, kafkaTopicProvisioner, KafkaStreamsMessageConversionDelegate2, KafkaStreamsBindingInformationCatalogue2, keyValueSerdeResolver, kafkaStreamsDlqDispatchers);
        kStreamBinder.setKafkaStreamsExtendedBindingProperties(kafkaStreamsExtendedBindingProperties);
        return kStreamBinder;
    }

    static class KStreamMissingBeansRegistrar
    extends KafkaStreamsBinderUtils.KafkaStreamsMissingBeansRegistrar {
        private static final String BEAN_NAME = "outerContext";

        KStreamMissingBeansRegistrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            super.registerBeanDefinitions(importingClassMetadata, registry);
            if (registry.containsBeanDefinition(BEAN_NAME)) {
                AbstractBeanDefinition converstionDelegateBean = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingFactoryBean.class).addPropertyReference("targetObject", BEAN_NAME).addPropertyValue("targetMethod", (Object)"getBean").addPropertyValue("arguments", KafkaStreamsMessageConversionDelegate.class).getBeanDefinition();
                registry.registerBeanDefinition(KafkaStreamsMessageConversionDelegate.class.getSimpleName(), (BeanDefinition)converstionDelegateBean);
                AbstractBeanDefinition keyValueSerdeResolverBean = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingFactoryBean.class).addPropertyReference("targetObject", BEAN_NAME).addPropertyValue("targetMethod", (Object)"getBean").addPropertyValue("arguments", KeyValueSerdeResolver.class).getBeanDefinition();
                registry.registerBeanDefinition(KeyValueSerdeResolver.class.getSimpleName(), (BeanDefinition)keyValueSerdeResolverBean);
                AbstractBeanDefinition kafkaStreamsExtendedBindingPropertiesBean = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingFactoryBean.class).addPropertyReference("targetObject", BEAN_NAME).addPropertyValue("targetMethod", (Object)"getBean").addPropertyValue("arguments", KafkaStreamsExtendedBindingProperties.class).getBeanDefinition();
                registry.registerBeanDefinition(KafkaStreamsExtendedBindingProperties.class.getSimpleName(), (BeanDefinition)kafkaStreamsExtendedBindingPropertiesBean);
            }
        }
    }
}

