/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kstream;

import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Produced;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaProducerProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kstream.MessageConversionDelegate;
import org.springframework.cloud.stream.binder.kstream.config.KStreamConsumerProperties;
import org.springframework.cloud.stream.binder.kstream.config.KStreamExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kstream.config.KStreamProducerProperties;
import org.springframework.util.StringUtils;

public class KStreamBinder
extends AbstractBinder<KStream<Object, Object>, ExtendedConsumerProperties<KStreamConsumerProperties>, ExtendedProducerProperties<KStreamProducerProperties>>
implements ExtendedPropertiesBinder<KStream<Object, Object>, KStreamConsumerProperties, KStreamProducerProperties> {
    private final KafkaTopicProvisioner kafkaTopicProvisioner;
    private final KStreamExtendedBindingProperties kStreamExtendedBindingProperties;
    private final StreamsConfig streamsConfig;
    private final KafkaBinderConfigurationProperties binderConfigurationProperties;
    private final MessageConversionDelegate messageConversionDelegate;

    public KStreamBinder(KafkaBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KStreamExtendedBindingProperties kStreamExtendedBindingProperties, StreamsConfig streamsConfig, MessageConversionDelegate messageConversionDelegate) {
        this.binderConfigurationProperties = binderConfigurationProperties;
        this.kafkaTopicProvisioner = kafkaTopicProvisioner;
        this.kStreamExtendedBindingProperties = kStreamExtendedBindingProperties;
        this.streamsConfig = streamsConfig;
        this.messageConversionDelegate = messageConversionDelegate;
    }

    protected Binding<KStream<Object, Object>> doBindConsumer(String name, String group, KStream<Object, Object> inputTarget, ExtendedConsumerProperties<KStreamConsumerProperties> properties) {
        ExtendedConsumerProperties extendedConsumerProperties = new ExtendedConsumerProperties((Object)new KafkaConsumerProperties());
        this.kafkaTopicProvisioner.provisionConsumerDestination(name, group, extendedConsumerProperties);
        return new DefaultBinding(name, group, inputTarget, null);
    }

    protected Binding<KStream<Object, Object>> doBindProducer(String name, KStream<Object, Object> outboundBindTarget, ExtendedProducerProperties<KStreamProducerProperties> properties) {
        ExtendedProducerProperties extendedProducerProperties = new ExtendedProducerProperties((Object)new KafkaProducerProperties());
        this.kafkaTopicProvisioner.provisionProducerDestination(name, extendedProducerProperties);
        Serde<?> keySerde = this.getKeySerde(properties);
        Serde<?> valueSerde = this.getValueSerde(properties);
        this.to(properties.isUseNativeEncoding(), name, outboundBindTarget, keySerde, valueSerde);
        return new DefaultBinding(name, null, outboundBindTarget, null);
    }

    private Serde<?> getKeySerde(ExtendedProducerProperties<KStreamProducerProperties> properties) {
        Serde keySerde;
        try {
            if (StringUtils.hasText((String)((KStreamProducerProperties)properties.getExtension()).getKeySerde())) {
                keySerde = (Serde)Utils.newInstance((String)((KStreamProducerProperties)properties.getExtension()).getKeySerde(), Serde.class);
                if (keySerde instanceof Configurable) {
                    ((Configurable)keySerde).configure(this.streamsConfig.originals());
                }
            } else {
                keySerde = this.binderConfigurationProperties.getConfiguration().containsKey("key.serde") ? (Serde)Utils.newInstance((String)((String)this.binderConfigurationProperties.getConfiguration().get("key.serde")), Serde.class) : Serdes.ByteArray();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Serde class not found: ", e);
        }
        return keySerde;
    }

    private Serde<?> getValueSerde(ExtendedProducerProperties<KStreamProducerProperties> properties) {
        Serde valueSerde;
        try {
            if (properties.isUseNativeEncoding()) {
                if (StringUtils.hasText((String)((KStreamProducerProperties)properties.getExtension()).getValueSerde())) {
                    valueSerde = (Serde)Utils.newInstance((String)((KStreamProducerProperties)properties.getExtension()).getValueSerde(), Serde.class);
                    if (valueSerde instanceof Configurable) {
                        ((Configurable)valueSerde).configure(this.streamsConfig.originals());
                    }
                } else {
                    valueSerde = this.binderConfigurationProperties.getConfiguration().containsKey("value.serde") ? (Serde)Utils.newInstance((String)((String)this.binderConfigurationProperties.getConfiguration().get("value.serde")), Serde.class) : Serdes.ByteArray();
                }
            } else {
                valueSerde = Serdes.ByteArray();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Serde class not found: ", e);
        }
        return valueSerde;
    }

    private void to(boolean isNativeEncoding, String name, KStream<Object, Object> outboundBindTarget, Serde<Object> keySerde, Serde<Object> valueSerde) {
        KeyValueMapper<Object, Object, KeyValue<Object, Object>> keyValueMapper = null;
        if (!isNativeEncoding) {
            keyValueMapper = this.messageConversionDelegate.outboundKeyValueMapper(name);
        }
        if (!isNativeEncoding) {
            outboundBindTarget.map(keyValueMapper).to(name, Produced.with(keySerde, valueSerde));
        } else {
            outboundBindTarget.to(name, Produced.with(keySerde, valueSerde));
        }
    }

    public KStreamConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.kStreamExtendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public KStreamProducerProperties getExtendedProducerProperties(String channelName) {
        return this.kStreamExtendedBindingProperties.getExtendedProducerProperties(channelName);
    }
}

