/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class MessageConversionDelegate {
    private final BindingServiceProperties bindingServiceProperties;
    private final CompositeMessageConverterFactory compositeMessageConverterFactory;

    public MessageConversionDelegate(BindingServiceProperties bindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        this.bindingServiceProperties = bindingServiceProperties;
        this.compositeMessageConverterFactory = compositeMessageConverterFactory;
    }

    public KeyValueMapper<Object, Object, KeyValue<Object, Object>> outboundKeyValueMapper(String name) {
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(name);
        String contentType = bindingProperties.getContentType();
        MessageConverter messageConverter = StringUtils.hasText((String)contentType) ? this.compositeMessageConverterFactory.getMessageConverterForType(MimeType.valueOf((String)contentType)) : null;
        return (k, v) -> {
            Message message = v instanceof Message ? (Message)v : MessageBuilder.withPayload((Object)v).build();
            HashMap<String, String> headers = new HashMap<String, String>((Map<String, String>)message.getHeaders());
            if (!StringUtils.isEmpty((Object)contentType)) {
                headers.put("contentType", contentType);
            }
            MessageHeaders messageHeaders = new MessageHeaders(headers);
            return new KeyValue(k, messageConverter.toMessage(message.getPayload(), messageHeaders).getPayload());
        };
    }

    public KeyValueMapper<Object, Object, KeyValue<Object, Object>> inboundKeyValueMapper(Class<?> valueClass) {
        CompositeMessageConverter messageConverter = this.compositeMessageConverterFactory.getMessageConverterForAllRegistered();
        return (arg_0, arg_1) -> MessageConversionDelegate.lambda$inboundKeyValueMapper$1(valueClass, (MessageConverter)messageConverter, arg_0, arg_1);
    }

    private static /* synthetic */ Object lambda$inboundKeyValueMapper$1(Class valueClass, MessageConverter messageConverter, Object o, Object o2) {
        KeyValue keyValue;
        if (valueClass.isAssignableFrom(o2.getClass())) {
            keyValue = new KeyValue(o, o2);
        } else if (o2 instanceof Message) {
            keyValue = valueClass.isAssignableFrom(((Message)o2).getPayload().getClass()) ? new KeyValue(o, ((Message)o2).getPayload()) : new KeyValue(o, messageConverter.fromMessage((Message)o2, valueClass));
        } else if (o2 instanceof String || o2 instanceof byte[]) {
            Message message = MessageBuilder.withPayload((Object)o2).build();
            keyValue = new KeyValue(o, messageConverter.fromMessage(message, valueClass));
        } else {
            keyValue = new KeyValue(o, o2);
        }
        return keyValue;
    }
}

