/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.UncategorizedAmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.LocalizedQueueConnectionFactory;
import org.springframework.amqp.rabbit.core.BatchingRabbitTemplate;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.core.support.BatchingStrategy;
import org.springframework.amqp.rabbit.core.support.SimpleBatchingStrategy;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.rabbit.retry.RepublishMessageRecoverer;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.rabbit.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitMessageChannelBinder
extends AbstractBinder<MessageChannel, ExtendedConsumerProperties<RabbitConsumerProperties>, ExtendedProducerProperties<RabbitProducerProperties>>
implements ExtendedPropertiesBinder<MessageChannel, RabbitConsumerProperties, RabbitProducerProperties> {
    public static final AnonymousQueue.Base64UrlNamingStrategy ANONYMOUS_GROUP_NAME_GENERATOR = new AnonymousQueue.Base64UrlNamingStrategy("anonymous.");
    private static final String DEAD_LETTER_EXCHANGE = "DLX";
    private static final MessagePropertiesConverter inboundMessagePropertiesConverter = new DefaultMessagePropertiesConverter(){

        public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
            MessageProperties properties = super.toMessageProperties(source, envelope, charset);
            properties.setDeliveryMode(null);
            return properties;
        }
    };
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RabbitAdmin rabbitAdmin;
    private final GenericApplicationContext autoDeclareContext = new GenericApplicationContext();
    private ConnectionFactory connectionFactory;
    private MessagePostProcessor decompressingPostProcessor = new DelegatingDecompressingPostProcessor();
    private MessagePostProcessor compressingPostProcessor = new GZipPostProcessor();
    private volatile String[] addresses;
    private volatile String[] adminAddresses;
    private volatile String[] nodes;
    private String username;
    private String password;
    private String vhost;
    private boolean useSSL;
    private Resource sslPropertiesLocation;
    private volatile boolean clustered;
    private RabbitExtendedBindingProperties extendedBindingProperties = new RabbitExtendedBindingProperties();

    public RabbitMessageChannelBinder(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        this.connectionFactory = connectionFactory;
        this.rabbitAdmin = new RabbitAdmin(connectionFactory);
        this.autoDeclareContext.refresh();
        this.rabbitAdmin.setApplicationContext((ApplicationContext)this.autoDeclareContext);
        this.rabbitAdmin.setIgnoreDeclarationExceptions(true);
        this.rabbitAdmin.afterPropertiesSet();
    }

    public void setDecompressingPostProcessor(MessagePostProcessor decompressingPostProcessor) {
        this.decompressingPostProcessor = decompressingPostProcessor;
    }

    public void setCompressingPostProcessor(MessagePostProcessor compressingPostProcessor) {
        this.compressingPostProcessor = compressingPostProcessor;
    }

    public void setAddresses(String[] addresses) {
        this.addresses = Arrays.copyOf(addresses, addresses.length);
    }

    public void setAdminAddresses(String[] adminAddresses) {
        this.adminAddresses = Arrays.copyOf(adminAddresses, adminAddresses.length);
    }

    public void setNodes(String[] nodes) {
        this.nodes = Arrays.copyOf(nodes, nodes.length);
        this.clustered = nodes.length > 1;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setExtendedBindingProperties(RabbitExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setSslPropertiesLocation(Resource sslPropertiesLocation) {
        this.sslPropertiesLocation = sslPropertiesLocation;
    }

    public void onInit() {
        if (this.clustered) {
            Assert.state((this.addresses.length == this.adminAddresses.length && this.addresses.length == this.nodes.length ? 1 : 0) != 0, (String)"'addresses', 'adminAddresses', and 'nodes' properties must have equal length");
            this.connectionFactory = new LocalizedQueueConnectionFactory(this.connectionFactory, this.addresses, this.adminAddresses, this.nodes, this.vhost, this.username, this.password, this.useSSL, this.sslPropertiesLocation);
        }
    }

    public RabbitConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public RabbitProducerProperties getExtendedProducerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public Binding<MessageChannel> doBindConsumer(String name, String group, MessageChannel inputChannel, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        Queue queue;
        boolean durable;
        String baseQueueName;
        boolean anonymousConsumer = !StringUtils.hasText((String)group);
        String string = baseQueueName = anonymousConsumer ? this.groupedName(name, ANONYMOUS_GROUP_NAME_GENERATOR.generateName()) : this.groupedName(name, group);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("declaring queue for inbound: " + baseQueueName + ", bound to: " + name);
        }
        String prefix = ((RabbitConsumerProperties)properties.getExtension()).getPrefix();
        String exchangeName = RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name);
        TopicExchange exchange = new TopicExchange(exchangeName);
        this.declareExchange(exchangeName, (Exchange)exchange);
        String queueName = RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)baseQueueName);
        boolean partitioned = !anonymousConsumer && properties.isPartitioned();
        boolean bl = durable = !anonymousConsumer && ((RabbitConsumerProperties)properties.getExtension()).isDurableSubscription();
        if (anonymousConsumer) {
            queue = new Queue(queueName, false, true, true);
        } else {
            if (partitioned) {
                String partitionSuffix = "-" + properties.getInstanceIndex();
                queueName = queueName + partitionSuffix;
            }
            queue = durable ? new Queue(queueName, true, false, false, this.queueArgs(queueName, ((RabbitConsumerProperties)properties.getExtension()).getPrefix(), ((RabbitConsumerProperties)properties.getExtension()).isAutoBindDlq())) : new Queue(queueName, false, false, true);
        }
        this.declareQueue(queueName, queue);
        if (partitioned) {
            String bindingKey = String.format("%s-%d", name, properties.getInstanceIndex());
            this.declareBinding(queue.getName(), BindingBuilder.bind((Queue)queue).to(exchange).with(bindingKey));
        } else {
            this.declareBinding(queue.getName(), BindingBuilder.bind((Queue)queue).to(exchange).with("#"));
        }
        Binding<MessageChannel> binding = this.doRegisterConsumer(baseQueueName, group, inputChannel, queue, properties);
        if (durable) {
            this.autoBindDLQ(RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)baseQueueName), queueName, ((RabbitConsumerProperties)properties.getExtension()).getPrefix(), ((RabbitConsumerProperties)properties.getExtension()).isAutoBindDlq());
        }
        return binding;
    }

    private Map<String, Object> queueArgs(String queueName, String prefix, boolean bindDlq) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (bindDlq) {
            args.put("x-dead-letter-exchange", RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)DEAD_LETTER_EXCHANGE));
            args.put("x-dead-letter-routing-key", queueName);
        }
        return args;
    }

    private Binding<MessageChannel> doRegisterConsumer(final String name, String group, MessageChannel moduleInputChannel, Queue queue, final ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(this.connectionFactory);
        listenerContainer.setAcknowledgeMode(((RabbitConsumerProperties)properties.getExtension()).getAcknowledgeMode());
        listenerContainer.setChannelTransacted(((RabbitConsumerProperties)properties.getExtension()).isTransacted());
        listenerContainer.setDefaultRequeueRejected(((RabbitConsumerProperties)properties.getExtension()).isRequeueRejected());
        int concurrency = properties.getConcurrency();
        concurrency = concurrency > 0 ? concurrency : 1;
        listenerContainer.setConcurrentConsumers(concurrency);
        int maxConcurrency = ((RabbitConsumerProperties)properties.getExtension()).getMaxConcurrency();
        if (maxConcurrency > concurrency) {
            listenerContainer.setMaxConcurrentConsumers(maxConcurrency);
        }
        listenerContainer.setPrefetchCount(((RabbitConsumerProperties)properties.getExtension()).getPrefetch());
        listenerContainer.setTxSize(((RabbitConsumerProperties)properties.getExtension()).getTxSize());
        listenerContainer.setTaskExecutor((Executor)new SimpleAsyncTaskExecutor(queue.getName() + "-"));
        listenerContainer.setQueues(new Queue[]{queue});
        int maxAttempts = properties.getMaxAttempts();
        if (maxAttempts > 1 || ((RabbitConsumerProperties)properties.getExtension()).isRepublishToDlq()) {
            RetryOperationsInterceptor retryInterceptor = (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().maxAttempts(maxAttempts).backOffOptions((long)properties.getBackOffInitialInterval(), properties.getBackOffMultiplier(), (long)properties.getBackOffMaxInterval()).recoverer(this.determineRecoverer(name, ((RabbitConsumerProperties)properties.getExtension()).getPrefix(), ((RabbitConsumerProperties)properties.getExtension()).isRepublishToDlq())).build();
            listenerContainer.setAdviceChain(new Advice[]{retryInterceptor});
        }
        listenerContainer.setAfterReceivePostProcessors(new MessagePostProcessor[]{this.decompressingPostProcessor});
        listenerContainer.setMessagePropertiesConverter(inboundMessagePropertiesConverter);
        listenerContainer.afterPropertiesSet();
        AmqpInboundChannelAdapter adapter = new AmqpInboundChannelAdapter((AbstractMessageListenerContainer)listenerContainer);
        adapter.setBeanFactory((BeanFactory)this.getBeanFactory());
        DirectChannel bridgeToModuleChannel = new DirectChannel();
        bridgeToModuleChannel.setBeanFactory((BeanFactory)this.getBeanFactory());
        bridgeToModuleChannel.setBeanName(name + ".bridge");
        adapter.setOutputChannel((MessageChannel)bridgeToModuleChannel);
        adapter.setBeanName("inbound." + name);
        DefaultAmqpHeaderMapper mapper = new DefaultAmqpHeaderMapper();
        mapper.setRequestHeaderNames(((RabbitConsumerProperties)properties.getExtension()).getRequestHeaderPatterns());
        mapper.setReplyHeaderNames(((RabbitConsumerProperties)properties.getExtension()).getReplyHeaderPatterns());
        adapter.setHeaderMapper((AmqpHeaderMapper)mapper);
        adapter.afterPropertiesSet();
        DefaultBinding<MessageChannel> consumerBinding = new DefaultBinding<MessageChannel>(name, group, moduleInputChannel, (AbstractEndpoint)adapter){

            protected void afterUnbind() {
                RabbitMessageChannelBinder.this.cleanAutoDeclareContext(((RabbitConsumerProperties)properties.getExtension()).getPrefix(), name);
            }
        };
        ReceivingHandler convertingBridge = new ReceivingHandler();
        convertingBridge.setOutputChannel(moduleInputChannel);
        convertingBridge.setBeanName(name + ".convert.bridge");
        convertingBridge.afterPropertiesSet();
        bridgeToModuleChannel.subscribe((MessageHandler)convertingBridge);
        adapter.start();
        return consumerBinding;
    }

    private MessageRecoverer determineRecoverer(String name, String prefix, boolean republish) {
        if (republish) {
            RabbitTemplate errorTemplate = new RabbitTemplate(this.connectionFactory);
            RepublishMessageRecoverer republishMessageRecoverer = new RepublishMessageRecoverer((AmqpTemplate)errorTemplate, this.deadLetterExchangeName(prefix), RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name));
            return republishMessageRecoverer;
        }
        return new RejectAndDontRequeueRecoverer();
    }

    private AmqpOutboundEndpoint buildOutboundEndpoint(String name, ExtendedProducerProperties<RabbitProducerProperties> properties, RabbitTemplate rabbitTemplate) {
        String prefix = ((RabbitProducerProperties)properties.getExtension()).getPrefix();
        String exchangeName = RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name);
        TopicExchange exchange = new TopicExchange(exchangeName);
        this.declareExchange(exchangeName, (Exchange)exchange);
        AmqpOutboundEndpoint endpoint = new AmqpOutboundEndpoint((AmqpTemplate)rabbitTemplate);
        endpoint.setExchangeName(exchange.getName());
        if (!properties.isPartitioned()) {
            endpoint.setRoutingKey(name);
        } else {
            endpoint.setExpressionRoutingKey(EXPRESSION_PARSER.parseExpression(this.buildPartitionRoutingExpression(name)));
        }
        for (String requiredGroupName : properties.getRequiredGroups()) {
            String baseQueueName = exchangeName + "." + requiredGroupName;
            if (!properties.isPartitioned()) {
                Queue queue = new Queue(baseQueueName, true, false, false, this.queueArgs(baseQueueName, prefix, ((RabbitProducerProperties)properties.getExtension()).isAutoBindDlq()));
                this.declareQueue(baseQueueName, queue);
                this.autoBindDLQ(baseQueueName, baseQueueName, ((RabbitProducerProperties)properties.getExtension()).getPrefix(), ((RabbitProducerProperties)properties.getExtension()).isAutoBindDlq());
                org.springframework.amqp.core.Binding binding = BindingBuilder.bind((Queue)queue).to(exchange).with(name);
                this.declareBinding(baseQueueName, binding);
                continue;
            }
            for (int i = 0; i < properties.getPartitionCount(); ++i) {
                String partitionSuffix = "-" + i;
                String partitionQueueName = baseQueueName + partitionSuffix;
                Queue queue = new Queue(partitionQueueName, true, false, false, this.queueArgs(partitionQueueName, ((RabbitProducerProperties)properties.getExtension()).getPrefix(), ((RabbitProducerProperties)properties.getExtension()).isAutoBindDlq()));
                this.declareQueue(queue.getName(), queue);
                this.autoBindDLQ(baseQueueName, baseQueueName + partitionSuffix, ((RabbitProducerProperties)properties.getExtension()).getPrefix(), ((RabbitProducerProperties)properties.getExtension()).isAutoBindDlq());
                this.declareBinding(queue.getName(), BindingBuilder.bind((Queue)queue).to(exchange).with(name + partitionSuffix));
            }
        }
        this.configureOutboundHandler(endpoint, properties);
        return endpoint;
    }

    private void configureOutboundHandler(AmqpOutboundEndpoint handler, ExtendedProducerProperties<RabbitProducerProperties> producerProperties) {
        DefaultAmqpHeaderMapper mapper = new DefaultAmqpHeaderMapper();
        mapper.setRequestHeaderNames(((RabbitProducerProperties)producerProperties.getExtension()).getRequestHeaderPatterns());
        mapper.setReplyHeaderNames(((RabbitProducerProperties)producerProperties.getExtension()).getReplyHeaderPatterns());
        handler.setHeaderMapper((AmqpHeaderMapper)mapper);
        handler.setDefaultDeliveryMode(((RabbitProducerProperties)producerProperties.getExtension()).getDeliveryMode());
        handler.setBeanFactory((BeanFactory)this.getBeanFactory());
        handler.afterPropertiesSet();
    }

    public Binding<MessageChannel> doBindProducer(String name, MessageChannel outputChannel, ExtendedProducerProperties<RabbitProducerProperties> producerProperties) {
        String exchangeName = RabbitMessageChannelBinder.applyPrefix((String)((RabbitProducerProperties)producerProperties.getExtension()).getPrefix(), (String)name);
        TopicExchange exchange = new TopicExchange(exchangeName);
        this.declareExchange(exchangeName, (Exchange)exchange);
        AmqpOutboundEndpoint endpoint = this.buildOutboundEndpoint(name, producerProperties, this.buildRabbitTemplate((RabbitProducerProperties)producerProperties.getExtension()));
        return this.doRegisterProducer(name, outputChannel, endpoint, producerProperties);
    }

    private RabbitTemplate buildRabbitTemplate(RabbitProducerProperties properties) {
        RabbitTemplate rabbitTemplate = null;
        if (properties.isBatchingEnabled()) {
            SimpleBatchingStrategy batchingStrategy = new SimpleBatchingStrategy(properties.getBatchSize(), properties.getBatchBufferLimit(), (long)properties.getBatchTimeout());
            rabbitTemplate = new BatchingRabbitTemplate((BatchingStrategy)batchingStrategy, (TaskScheduler)this.getApplicationContext().getBean("taskScheduler", TaskScheduler.class));
        } else {
            rabbitTemplate = new RabbitTemplate();
        }
        rabbitTemplate.setConnectionFactory(this.connectionFactory);
        if (properties.isCompress()) {
            rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{this.compressingPostProcessor});
        }
        rabbitTemplate.setChannelTransacted(properties.isTransacted());
        rabbitTemplate.afterPropertiesSet();
        return rabbitTemplate;
    }

    private Binding<MessageChannel> doRegisterProducer(String name, MessageChannel moduleOutputChannel, AmqpOutboundEndpoint delegate, ExtendedProducerProperties<RabbitProducerProperties> properties) {
        return this.doRegisterProducer(name, moduleOutputChannel, delegate, null, properties);
    }

    private Binding<MessageChannel> doRegisterProducer(String name, MessageChannel moduleOutputChannel, AmqpOutboundEndpoint delegate, String replyTo, ExtendedProducerProperties<RabbitProducerProperties> properties) {
        Assert.isInstanceOf(SubscribableChannel.class, (Object)moduleOutputChannel);
        SendingHandler handler = new SendingHandler((MessageHandler)delegate, replyTo, properties);
        EventDrivenConsumer consumer = new EventDrivenConsumer((SubscribableChannel)moduleOutputChannel, (MessageHandler)handler);
        consumer.setBeanFactory((BeanFactory)this.getBeanFactory());
        consumer.setBeanName("outbound." + name);
        consumer.afterPropertiesSet();
        DefaultBinding producerBinding = new DefaultBinding(name, null, (Object)moduleOutputChannel, (AbstractEndpoint)consumer);
        consumer.start();
        return producerBinding;
    }

    private void autoBindDLQ(String queueName, String routingKey, String prefix, boolean autoBindDlq) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("autoBindDLQ=" + autoBindDlq + " for: " + queueName);
        }
        if (autoBindDlq) {
            String dlqName = RabbitMessageChannelBinder.constructDLQName((String)queueName);
            Queue dlq = new Queue(dlqName);
            this.declareQueue(dlqName, dlq);
            String dlxName = this.deadLetterExchangeName(prefix);
            DirectExchange dlx = new DirectExchange(dlxName);
            this.declareExchange(dlxName, (Exchange)dlx);
            this.declareBinding(dlqName, BindingBuilder.bind((Queue)dlq).to(dlx).with(routingKey));
        }
    }

    public void declareQueue(String beanName, Queue queue) {
        block4: {
            try {
                this.rabbitAdmin.declareQueue(queue);
            }
            catch (AmqpConnectException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Declaration of queue: " + queue.getName() + " deferred - connection not available");
                }
            }
            catch (UncategorizedAmqpException e) {
                if (e.getCause() instanceof NullPointerException) break block4;
                throw e;
            }
        }
        this.addToAutoDeclareContext(beanName, queue);
    }

    public void declareExchange(String rootName, Exchange exchange) {
        block2: {
            try {
                this.rabbitAdmin.declareExchange(exchange);
            }
            catch (AmqpConnectException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Declaration of exchange: " + exchange.getName() + " deferred - connection not available");
            }
        }
        this.addToAutoDeclareContext(rootName + ".exchange", exchange);
    }

    public void declareBinding(String rootName, org.springframework.amqp.core.Binding binding) {
        block2: {
            try {
                this.rabbitAdmin.declareBinding(binding);
            }
            catch (AmqpConnectException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Declaration of binding: " + rootName + ".binding deferred - connection not available");
            }
        }
        this.addToAutoDeclareContext(rootName + ".binding", binding);
    }

    private String deadLetterExchangeName(String prefix) {
        return prefix + DEAD_LETTER_EXCHANGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAutoDeclareContext(String name, Object bean) {
        GenericApplicationContext genericApplicationContext = this.autoDeclareContext;
        synchronized (genericApplicationContext) {
            if (!this.autoDeclareContext.containsBean(name)) {
                this.autoDeclareContext.getBeanFactory().registerSingleton(name, bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAutoDeclareContext(String prefix, String name) {
        GenericApplicationContext genericApplicationContext = this.autoDeclareContext;
        synchronized (genericApplicationContext) {
            this.removeSingleton(RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name) + ".binding");
            this.removeSingleton(RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name));
            String dlq = RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name) + ".dlq";
            this.removeSingleton(dlq + ".binding");
            this.removeSingleton(dlq);
        }
    }

    private void removeSingleton(String name) {
        ConfigurableListableBeanFactory beanFactory;
        if (this.autoDeclareContext.containsBean(name) && (beanFactory = this.autoDeclareContext.getBeanFactory()) instanceof DefaultListableBeanFactory) {
            ((DefaultListableBeanFactory)beanFactory).destroySingleton(name);
        }
    }

    public void doManualAck(LinkedList<MessageHeaders> messageHeadersList) {
        Iterator iterator = messageHeadersList.iterator();
        HashMap<Channel, Long> channelsToAck = new HashMap<Channel, Long>();
        while (iterator.hasNext()) {
            MessageHeaders messageHeaders = (MessageHeaders)iterator.next();
            if (!messageHeaders.containsKey((Object)"amqp_channel")) continue;
            Channel channel = (Channel)messageHeaders.get((Object)"amqp_channel");
            Long deliveryTag = (Long)messageHeaders.get((Object)"amqp_deliveryTag");
            channelsToAck.put(channel, deliveryTag);
        }
        for (Map.Entry entry : channelsToAck.entrySet()) {
            try {
                ((Channel)entry.getKey()).basicAck(((Long)entry.getValue()).longValue(), true);
            }
            catch (IOException e) {
                this.logger.error("Exception while manually acknowledging " + e);
            }
        }
    }

    private class ReceivingHandler
    extends AbstractReplyProducingMessageHandler {
        public ReceivingHandler() {
            this.setBeanFactory((BeanFactory)RabbitMessageChannelBinder.this.getBeanFactory());
        }

        protected Object handleRequestMessage(Message<?> requestMessage) {
            return RabbitMessageChannelBinder.this.deserializePayloadIfNecessary(requestMessage).toMessage(this.getMessageBuilderFactory());
        }

        protected boolean shouldCopyRequestHeaders() {
            return false;
        }
    }

    private class SendingHandler
    extends AbstractMessageHandler
    implements Lifecycle {
        private final MessageHandler delegate;
        private final String replyTo;
        private final ExtendedProducerProperties<RabbitProducerProperties> producerProperties;
        private final PartitionHandler partitionHandler;

        private SendingHandler(MessageHandler delegate, String replyTo, ExtendedProducerProperties<RabbitProducerProperties> properties) {
            this.delegate = delegate;
            this.replyTo = replyTo;
            this.producerProperties = properties;
            ConfigurableListableBeanFactory beanFactory = RabbitMessageChannelBinder.this.getBeanFactory();
            this.setBeanFactory((BeanFactory)beanFactory);
            this.partitionHandler = new PartitionHandler(beanFactory, RabbitMessageChannelBinder.this.evaluationContext, RabbitMessageChannelBinder.this.partitionSelector, properties);
        }

        protected void handleMessageInternal(Message<?> message) throws Exception {
            MessageValues messageToSend = RabbitMessageChannelBinder.this.serializePayloadIfNecessary(message);
            if (this.replyTo != null) {
                messageToSend.put("amqp_replyTo", (Object)this.replyTo);
            }
            if (this.producerProperties.isPartitioned()) {
                messageToSend.put("partition", (Object)this.partitionHandler.determinePartition(message));
            }
            this.delegate.handleMessage(messageToSend.toMessage(this.getMessageBuilderFactory()));
        }

        public void start() {
            if (this.delegate instanceof Lifecycle) {
                ((Lifecycle)this.delegate).start();
            }
        }

        public void stop() {
            if (this.delegate instanceof Lifecycle) {
                ((Lifecycle)this.delegate).stop();
            }
        }

        public boolean isRunning() {
            if (this.delegate instanceof Lifecycle) {
                return ((Lifecycle)this.delegate).isRunning();
            }
            return true;
        }
    }
}

