/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitProducerProperties;

@ConfigurationProperties(value="spring.cloud.stream.rabbit")
public class RabbitExtendedBindingProperties
implements ExtendedBindingProperties<RabbitConsumerProperties, RabbitProducerProperties> {
    private Map<String, RabbitBindingProperties> bindings = new HashMap<String, RabbitBindingProperties>();

    public Map<String, RabbitBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, RabbitBindingProperties> bindings) {
        this.bindings = bindings;
    }

    public RabbitConsumerProperties getExtendedConsumerProperties(String channelName) {
        if (this.bindings.containsKey(channelName) && this.bindings.get(channelName).getConsumer() != null) {
            return this.bindings.get(channelName).getConsumer();
        }
        return new RabbitConsumerProperties();
    }

    public RabbitProducerProperties getExtendedProducerProperties(String channelName) {
        if (this.bindings.containsKey(channelName) && this.bindings.get(channelName).getProducer() != null) {
            return this.bindings.get(channelName).getProducer();
        }
        return new RabbitProducerProperties();
    }
}

