/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.LocalizedQueueConnectionFactory;
import org.springframework.amqp.rabbit.core.BatchingRabbitTemplate;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.core.support.BatchingStrategy;
import org.springframework.amqp.rabbit.core.support.SimpleBatchingStrategy;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.rabbit.retry.RepublishMessageRecoverer;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitCommonProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitProducerProperties;
import org.springframework.cloud.stream.binder.rabbit.provisioning.RabbitExchangeQueueProvisioner;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.core.MessageProducer;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<RabbitConsumerProperties>, ExtendedProducerProperties<RabbitProducerProperties>, RabbitExchangeQueueProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, RabbitConsumerProperties, RabbitProducerProperties> {
    private static final MessagePropertiesConverter inboundMessagePropertiesConverter = new DefaultMessagePropertiesConverter(){

        public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
            MessageProperties properties = super.toMessageProperties(source, envelope, charset);
            properties.setDeliveryMode(null);
            return properties;
        }
    };
    private final RabbitProperties rabbitProperties;
    private ConnectionFactory connectionFactory;
    private MessagePostProcessor decompressingPostProcessor = new DelegatingDecompressingPostProcessor();
    private MessagePostProcessor compressingPostProcessor = new GZipPostProcessor();
    private volatile String[] adminAddresses;
    private volatile String[] nodes;
    private volatile boolean clustered;
    private RabbitExtendedBindingProperties extendedBindingProperties = new RabbitExtendedBindingProperties();

    public RabbitMessageChannelBinder(ConnectionFactory connectionFactory, RabbitProperties rabbitProperties, RabbitExchangeQueueProvisioner provisioningProvider) {
        super(true, new String[0], (ProvisioningProvider)provisioningProvider);
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        Assert.notNull((Object)rabbitProperties, (String)"rabbitProperties must not be null");
        this.connectionFactory = connectionFactory;
        this.rabbitProperties = rabbitProperties;
    }

    public void setDecompressingPostProcessor(MessagePostProcessor decompressingPostProcessor) {
        this.decompressingPostProcessor = decompressingPostProcessor;
    }

    public void setCompressingPostProcessor(MessagePostProcessor compressingPostProcessor) {
        this.compressingPostProcessor = compressingPostProcessor;
    }

    public void setAdminAddresses(String[] adminAddresses) {
        this.adminAddresses = Arrays.copyOf(adminAddresses, adminAddresses.length);
    }

    public void setNodes(String[] nodes) {
        this.nodes = Arrays.copyOf(nodes, nodes.length);
        this.clustered = nodes.length > 1;
    }

    public void setExtendedBindingProperties(RabbitExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    public void onInit() {
        if (this.clustered) {
            String[] addresses = StringUtils.commaDelimitedListToStringArray((String)this.rabbitProperties.getAddresses());
            Assert.state((addresses.length == this.adminAddresses.length && addresses.length == this.nodes.length ? 1 : 0) != 0, (String)"'addresses', 'adminAddresses', and 'nodes' properties must have equal length");
            this.connectionFactory = new LocalizedQueueConnectionFactory(this.connectionFactory, addresses, this.adminAddresses, this.nodes, this.rabbitProperties.getVirtualHost(), this.rabbitProperties.getUsername(), this.rabbitProperties.getPassword(), this.rabbitProperties.getSsl().isEnabled(), this.rabbitProperties.getSsl().getKeyStore(), this.rabbitProperties.getSsl().getTrustStore(), this.rabbitProperties.getSsl().getKeyStorePassword(), this.rabbitProperties.getSsl().getTrustStorePassword());
        }
    }

    public RabbitConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public RabbitProducerProperties getExtendedProducerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination producerDestination, ExtendedProducerProperties<RabbitProducerProperties> producerProperties) throws Exception {
        String prefix = ((RabbitProducerProperties)producerProperties.getExtension()).getPrefix();
        String exchangeName = producerDestination.getName();
        String destination = StringUtils.isEmpty((Object)prefix) ? exchangeName : exchangeName.substring(prefix.length());
        AmqpOutboundEndpoint endpoint = new AmqpOutboundEndpoint((AmqpTemplate)this.buildRabbitTemplate((RabbitProducerProperties)producerProperties.getExtension()));
        endpoint.setExchangeName(producerDestination.getName());
        RabbitProducerProperties extendedProperties = (RabbitProducerProperties)producerProperties.getExtension();
        String routingKeyExpression = extendedProperties.getRoutingKeyExpression();
        if (!producerProperties.isPartitioned()) {
            if (routingKeyExpression == null) {
                endpoint.setRoutingKey(destination);
            } else {
                endpoint.setRoutingKeyExpressionString(routingKeyExpression);
            }
        } else if (routingKeyExpression == null) {
            endpoint.setRoutingKeyExpressionString(this.buildPartitionRoutingExpression(destination, false));
        } else {
            endpoint.setRoutingKeyExpressionString(this.buildPartitionRoutingExpression(routingKeyExpression, true));
        }
        if (extendedProperties.getDelayExpression() != null) {
            endpoint.setDelayExpressionString(extendedProperties.getDelayExpression());
        }
        DefaultAmqpHeaderMapper mapper = DefaultAmqpHeaderMapper.outboundMapper();
        ArrayList<String> headerPatterns = new ArrayList<String>(extendedProperties.getHeaderPatterns().length + 1);
        headerPatterns.add("!scst_partition");
        headerPatterns.addAll(Arrays.asList(extendedProperties.getHeaderPatterns()));
        mapper.setRequestHeaderNames(headerPatterns.toArray(new String[headerPatterns.size()]));
        endpoint.setHeaderMapper((AmqpHeaderMapper)mapper);
        endpoint.setDefaultDeliveryMode(extendedProperties.getDeliveryMode());
        endpoint.setBeanFactory((BeanFactory)this.getBeanFactory());
        endpoint.afterPropertiesSet();
        return endpoint;
    }

    private String buildPartitionRoutingExpression(String expressionRoot, boolean rootIsExpression) {
        return rootIsExpression ? expressionRoot + " + '-' + headers['" + "scst_partition" + "']" : "'" + expressionRoot + "-' + headers['" + "scst_partition" + "']";
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination consumerDestination, String group, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        String prefix = ((RabbitConsumerProperties)properties.getExtension()).getPrefix();
        String destination = consumerDestination.getName();
        String prefixStripped = StringUtils.isEmpty((Object)prefix) || !destination.startsWith(prefix) ? destination : destination.substring(prefix.length());
        String baseQueueName = StringUtils.hasText((String)group) ? prefixStripped.substring(0, prefixStripped.indexOf(group)) + group : prefixStripped;
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(this.connectionFactory);
        listenerContainer.setAcknowledgeMode(((RabbitConsumerProperties)properties.getExtension()).getAcknowledgeMode());
        listenerContainer.setChannelTransacted(((RabbitConsumerProperties)properties.getExtension()).isTransacted());
        listenerContainer.setDefaultRequeueRejected(((RabbitConsumerProperties)properties.getExtension()).isRequeueRejected());
        int concurrency = properties.getConcurrency();
        concurrency = concurrency > 0 ? concurrency : 1;
        listenerContainer.setConcurrentConsumers(concurrency);
        int maxConcurrency = ((RabbitConsumerProperties)properties.getExtension()).getMaxConcurrency();
        if (maxConcurrency > concurrency) {
            listenerContainer.setMaxConcurrentConsumers(maxConcurrency);
        }
        listenerContainer.setPrefetchCount(((RabbitConsumerProperties)properties.getExtension()).getPrefetch());
        listenerContainer.setRecoveryInterval(((RabbitConsumerProperties)properties.getExtension()).getRecoveryInterval());
        listenerContainer.setTxSize(((RabbitConsumerProperties)properties.getExtension()).getTxSize());
        listenerContainer.setTaskExecutor((Executor)new SimpleAsyncTaskExecutor(consumerDestination.getName() + "-"));
        listenerContainer.setQueueNames(new String[]{consumerDestination.getName()});
        if (properties.getMaxAttempts() > 1 || ((RabbitConsumerProperties)properties.getExtension()).isRepublishToDlq()) {
            RetryOperationsInterceptor retryInterceptor = (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().retryOperations((RetryOperations)this.buildRetryTemplate((ConsumerProperties)properties)).recoverer(this.determineRecoverer(baseQueueName, (RabbitConsumerProperties)properties.getExtension())).build();
            listenerContainer.setAdviceChain(new Advice[]{retryInterceptor});
        }
        listenerContainer.setAfterReceivePostProcessors(new MessagePostProcessor[]{this.decompressingPostProcessor});
        listenerContainer.setMessagePropertiesConverter(inboundMessagePropertiesConverter);
        listenerContainer.afterPropertiesSet();
        AmqpInboundChannelAdapter adapter = new AmqpInboundChannelAdapter((AbstractMessageListenerContainer)listenerContainer);
        adapter.setBeanFactory((BeanFactory)this.getBeanFactory());
        adapter.setBeanName("inbound." + baseQueueName);
        DefaultAmqpHeaderMapper mapper = DefaultAmqpHeaderMapper.inboundMapper();
        mapper.setRequestHeaderNames(((RabbitConsumerProperties)properties.getExtension()).getHeaderPatterns());
        adapter.setHeaderMapper((AmqpHeaderMapper)mapper);
        adapter.afterPropertiesSet();
        return adapter;
    }

    private String deadLetterExchangeName(RabbitCommonProperties properties) {
        if (properties.getDeadLetterExchange() == null) {
            return properties.getPrefix() + "DLX";
        }
        return properties.getDeadLetterExchange();
    }

    protected void afterUnbindConsumer(ConsumerDestination consumerDestination, String group, ExtendedConsumerProperties<RabbitConsumerProperties> consumerProperties) {
        ((RabbitExchangeQueueProvisioner)this.provisioningProvider).cleanAutoDeclareContext(consumerDestination.getName());
    }

    private MessageRecoverer determineRecoverer(String name, final RabbitConsumerProperties properties) {
        if (properties.isRepublishToDlq()) {
            RabbitTemplate errorTemplate = new RabbitTemplate(this.connectionFactory);
            if (properties.getRepublishDeliveyMode() != null) {
                return new RepublishMessageRecoverer((AmqpTemplate)errorTemplate, this.deadLetterExchangeName((RabbitCommonProperties)properties), RabbitMessageChannelBinder.applyPrefix((String)properties.getPrefix(), (String)name)){

                    public void recover(Message message, Throwable cause) {
                        message.getMessageProperties().setDeliveryMode(properties.getRepublishDeliveyMode());
                        super.recover(message, cause);
                    }
                };
            }
            return new RepublishMessageRecoverer((AmqpTemplate)errorTemplate, this.deadLetterExchangeName((RabbitCommonProperties)properties), RabbitMessageChannelBinder.applyPrefix((String)properties.getPrefix(), (String)name));
        }
        return new RejectAndDontRequeueRecoverer();
    }

    private RabbitTemplate buildRabbitTemplate(RabbitProducerProperties properties) {
        RabbitTemplate rabbitTemplate;
        if (properties.isBatchingEnabled()) {
            SimpleBatchingStrategy batchingStrategy = new SimpleBatchingStrategy(properties.getBatchSize(), properties.getBatchBufferLimit(), (long)properties.getBatchTimeout());
            rabbitTemplate = new BatchingRabbitTemplate((BatchingStrategy)batchingStrategy, (TaskScheduler)this.getApplicationContext().getBean("taskScheduler", TaskScheduler.class));
        } else {
            rabbitTemplate = new RabbitTemplate();
        }
        rabbitTemplate.setConnectionFactory(this.connectionFactory);
        if (properties.isCompress()) {
            rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{this.compressingPostProcessor});
        }
        rabbitTemplate.setChannelTransacted(properties.isTransacted());
        rabbitTemplate.afterPropertiesSet();
        return rabbitTemplate;
    }
}

