/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.test.matcher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.springframework.integration.util.Function;
import org.springframework.messaging.Message;

public class MessageQueueMatcher<T>
extends BaseMatcher<BlockingQueue<Message<?>>> {
    private final Matcher<T> delegate;
    private final long timeout;
    private final TimeUnit unit;
    private Extractor<Message<?>, T> extractor;
    private Map<BlockingQueue<Message<?>>, T> actuallyReceived = new HashMap();

    public MessageQueueMatcher(Matcher<T> delegate, long timeout, TimeUnit unit, Extractor<Message<?>, T> extractor) {
        this.delegate = delegate;
        this.timeout = timeout;
        this.unit = unit != null ? unit : TimeUnit.SECONDS;
        this.extractor = extractor;
    }

    public static <P> MessageQueueMatcher<P> receivesMessageThat(Matcher<Message<P>> messageMatcher) {
        return new MessageQueueMatcher<Message<P>>(messageMatcher, 5L, TimeUnit.SECONDS, new Extractor<Message<P>, Message<P>>("a message that "){

            public Message<P> apply(Message<P> m) {
                return m;
            }
        });
    }

    public static <P> MessageQueueMatcher<P> receivesPayloadThat(Matcher<P> payloadMatcher) {
        return new MessageQueueMatcher<P>(payloadMatcher, 5L, TimeUnit.SECONDS, new Extractor<Message<P>, P>("a message whose payload "){

            public P apply(Message<P> m) {
                return m.getPayload();
            }
        });
    }

    public boolean matches(Object item) {
        BlockingQueue queue = (BlockingQueue)item;
        Message received = null;
        try {
            received = this.timeout > 0L ? (Message)queue.poll(this.timeout, this.unit) : (this.timeout == 0L ? (Message)queue.poll() : (Message)queue.take());
        }
        catch (InterruptedException e) {
            return false;
        }
        Object unwrapped = this.extractor.apply(received);
        this.actuallyReceived.put(queue, unwrapped);
        return this.delegate.matches(unwrapped);
    }

    public void describeMismatch(Object item, Description description) {
        BlockingQueue queue = (BlockingQueue)item;
        T value = this.actuallyReceived.get(queue);
        if (value != null) {
            description.appendText("received: ").appendValue(value);
        } else {
            description.appendText("timed out after " + this.timeout + " " + this.unit.name().toLowerCase());
        }
    }

    public MessageQueueMatcher<T> within(long timeout, TimeUnit unit) {
        return new MessageQueueMatcher<T>(this.delegate, timeout, unit, this.extractor);
    }

    public MessageQueueMatcher<T> immediately() {
        return new MessageQueueMatcher<T>(this.delegate, 0L, null, this.extractor);
    }

    public MessageQueueMatcher<T> indefinitely() {
        return new MessageQueueMatcher<T>(this.delegate, -1L, null, this.extractor);
    }

    public void describeTo(Description description) {
        description.appendText("Channel to receive ").appendDescriptionOf(this.extractor).appendDescriptionOf(this.delegate);
    }

    public static abstract class Extractor<R, T>
    implements Function<R, T>,
    SelfDescribing {
        private final String behaviorDescription;

        protected Extractor(String behaviorDescription) {
            this.behaviorDescription = behaviorDescription;
        }

        public void describeTo(Description description) {
            description.appendText(this.behaviorDescription);
        }
    }
}

