/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.cloud.stream.binding.BindableChannelFactory;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.SubscribableChannel;

public class DefaultBindableChannelFactory
implements BindableChannelFactory {
    private final MessageChannelConfigurer messageChannelConfigurer;

    public DefaultBindableChannelFactory(MessageChannelConfigurer messageChannelConfigurer) {
        this.messageChannelConfigurer = messageChannelConfigurer;
    }

    @Override
    public PollableChannel createPollableChannel(String name) {
        QueueChannel pollableChannel = new QueueChannel();
        this.messageChannelConfigurer.configureMessageChannel((MessageChannel)pollableChannel, name);
        return pollableChannel;
    }

    @Override
    public SubscribableChannel createSubscribableChannel(String name) {
        DirectChannel subscribableChannel = new DirectChannel();
        this.messageChannelConfigurer.configureMessageChannel((MessageChannel)subscribableChannel, name);
        return subscribableChannel;
    }
}

