/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.aggregate;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.Banner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.aggregate.AggregateApplicationBuilder;
import org.springframework.cloud.stream.aggregate.SharedChannelRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.messaging.MessageChannel;

abstract class AggregateApplication {
    private static final String SPRING_CLOUD_STREAM_INTERNAL_PREFIX = "spring.cloud.stream.internal";
    private static final String CHANNEL_NAMESPACE_PROPERTY_NAME = "spring.cloud.stream.internal.channelNamespace";
    private static final String SELF_CONTAINED_APP_PROPERTY_NAME = "spring.cloud.stream.internal.selfContained";
    public static final String INPUT_CHANNEL_NAME = "input";
    public static final String OUTPUT_CHANNEL_NAME = "output";

    AggregateApplication() {
    }

    static ConfigurableApplicationContext createParentContext(Object[] sources, String[] args, boolean selfContained, boolean webEnvironment, boolean headless) {
        SpringApplicationBuilder aggregatorParentConfiguration = new SpringApplicationBuilder(new Object[0]);
        aggregatorParentConfiguration.sources(sources).web(webEnvironment).headless(headless).properties(new String[]{"spring.jmx.default-domain=" + AggregateApplicationBuilder.ParentConfiguration.class.getName(), "spring.cloud.stream.internal.selfContained=" + selfContained});
        return aggregatorParentConfiguration.run(args);
    }

    static String getDefaultNamespace(String appClassName, int index) {
        return appClassName + "_" + index;
    }

    protected static SpringApplicationBuilder embedApp(ConfigurableApplicationContext parentContext, String namespace, Class<?> app) {
        return new SpringApplicationBuilder(new Object[]{app}).web(false).main(app).bannerMode(Banner.Mode.OFF).properties(new String[]{"spring.jmx.default-domain=" + namespace}).properties(new String[]{"spring.cloud.stream.internal.channelNamespace=" + namespace}).registerShutdownHook(false).parent(parentContext);
    }

    static void prepareSharedChannelRegistry(SharedChannelRegistry sharedChannelRegistry, LinkedHashMap<Class<?>, String> appsWithNamespace) {
        int i = 0;
        DirectChannel sharedChannel = null;
        for (Map.Entry<Class<?>, String> appEntry : appsWithNamespace.entrySet()) {
            String namespace = appEntry.getValue();
            if (i > 0) {
                sharedChannelRegistry.register(namespace + "." + INPUT_CHANNEL_NAME, (MessageChannel)sharedChannel);
            }
            sharedChannel = new DirectChannel();
            if (i < appsWithNamespace.size() - 1) {
                sharedChannelRegistry.register(namespace + "." + OUTPUT_CHANNEL_NAME, (MessageChannel)sharedChannel);
            }
            ++i;
        }
    }
}

