/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.binder.DefaultBinderTypeRegistry;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@Role(value=2)
public class BinderFactoryConfiguration {
    private static final String SPRING_CLOUD_STREAM_INTERNAL_PREFIX = "spring.cloud.stream.internal";
    private static final String SELF_CONTAINED_APP_PROPERTY_NAME = "spring.cloud.stream.internal.selfContained";
    @Value(value="${spring.cloud.stream.internal.selfContained:}")
    private String selfContained;
    @Autowired(required=false)
    private Collection<DefaultBinderFactory.Listener> binderFactoryListeners;

    static Collection<BinderType> parseBinderConfigurations(ClassLoader classLoader, Resource resource) throws IOException, ClassNotFoundException {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        ArrayList<BinderType> parsedBinderConfigurations = new ArrayList<BinderType>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String binderType = (String)entry.getKey();
            String[] binderConfigurationClassNames = StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue()));
            Class[] binderConfigurationClasses = new Class[binderConfigurationClassNames.length];
            int i = 0;
            for (String binderConfigurationClassName : binderConfigurationClassNames) {
                binderConfigurationClasses[i++] = ClassUtils.forName((String)binderConfigurationClassName, (ClassLoader)classLoader);
            }
            parsedBinderConfigurations.add(new BinderType(binderType, binderConfigurationClasses));
        }
        return parsedBinderConfigurations;
    }

    @Bean
    @ConditionalOnMissingBean(value={BinderFactory.class})
    public DefaultBinderFactory binderFactory(BinderTypeRegistry binderTypeRegistry, BindingServiceProperties bindingServiceProperties) {
        DefaultBinderFactory binderFactory = new DefaultBinderFactory(this.getBinderConfigurations(binderTypeRegistry, bindingServiceProperties), binderTypeRegistry);
        binderFactory.setDefaultBinder(bindingServiceProperties.getDefaultBinder());
        binderFactory.setListeners(this.binderFactoryListeners);
        return binderFactory;
    }

    private Map<String, BinderConfiguration> getBinderConfigurations(BinderTypeRegistry binderTypeRegistry, BindingServiceProperties bindingServiceProperties) {
        HashMap<String, BinderConfiguration> binderConfigurations = new HashMap<String, BinderConfiguration>();
        Map<String, BinderProperties> declaredBinders = bindingServiceProperties.getBinders();
        boolean defaultCandidatesExist = false;
        Iterator<Map.Entry<String, BinderProperties>> binderPropertiesIterator = declaredBinders.entrySet().iterator();
        while (!defaultCandidatesExist && binderPropertiesIterator.hasNext()) {
            defaultCandidatesExist = binderPropertiesIterator.next().getValue().isDefaultCandidate();
        }
        ArrayList<String> existingBinderConfigurations = new ArrayList<String>();
        for (Map.Entry<String, BinderProperties> entry : declaredBinders.entrySet()) {
            BinderProperties binderProperties = entry.getValue();
            if (binderTypeRegistry.get(entry.getKey()) != null) {
                binderConfigurations.put(entry.getKey(), new BinderConfiguration(entry.getKey(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
                existingBinderConfigurations.add(entry.getKey());
                continue;
            }
            Assert.hasText((String)binderProperties.getType(), (String)("No 'type' property present for custom binder " + entry.getKey()));
            binderConfigurations.put(entry.getKey(), new BinderConfiguration(binderProperties.getType(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
            existingBinderConfigurations.add(entry.getKey());
        }
        for (Map.Entry<String, BinderProperties> entry : binderConfigurations.entrySet()) {
            if (!((BinderConfiguration)((Object)entry.getValue())).isDefaultCandidate()) continue;
            defaultCandidatesExist = true;
        }
        if (!defaultCandidatesExist) {
            for (Map.Entry<String, Object> entry : binderTypeRegistry.getAll().entrySet()) {
                if (existingBinderConfigurations.contains(entry.getKey())) continue;
                binderConfigurations.put(entry.getKey(), new BinderConfiguration(entry.getKey(), new HashMap<Object, Object>(), true, true));
            }
        }
        return binderConfigurations;
    }

    @Bean
    @ConditionalOnMissingBean(value={BinderTypeRegistry.class})
    public BinderTypeRegistry binderTypeRegistry(ConfigurableApplicationContext configurableApplicationContext) {
        HashMap<String, BinderType> binderTypes = new HashMap<String, BinderType>();
        ClassLoader classLoader = configurableApplicationContext.getClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/spring.binders");
            if (!(Boolean.valueOf(this.selfContained).booleanValue() || resources != null && resources.hasMoreElements())) {
                throw new BeanCreationException("Cannot create binder factory, no `META-INF/spring.binders` resources found on the classpath");
            }
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                UrlResource resource = new UrlResource(url);
                for (BinderType binderType : BinderFactoryConfiguration.parseBinderConfigurations(classLoader, (Resource)resource)) {
                    binderTypes.put(binderType.getDefaultName(), binderType);
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new BeanCreationException("Cannot create binder factory:", (Throwable)e);
        }
        return new DefaultBinderTypeRegistry(binderTypes);
    }
}

