/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.List;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.endpoint.BindingsEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.annotation.Endpoint"})
@ConditionalOnBean(value={BindingService.class})
@AutoConfigureAfter(value={EndpointAutoConfiguration.class})
public class BindingsEndpointAutoConfiguration {
    @Bean
    public BindingsEndpoint bindingsEndpoint(List<InputBindingLifecycle> inputBindings) {
        return new BindingsEndpoint(inputBindings);
    }

    @Bean
    public BindingsEndpoint.StopEndpoint stopEndpoint(BindingsEndpoint bindingEndpoint) {
        return bindingEndpoint.getStopEndpoint();
    }

    @Bean
    public BindingsEndpoint.PauseEndpoint pauseEndpoint(BindingsEndpoint bindingEndpoint) {
        return bindingEndpoint.getPauseEndpoint();
    }

    @Bean
    public BindingsEndpoint.StartEndpoint startEndpoint(BindingsEndpoint bindingEndpoint) {
        return bindingEndpoint.getStartEndpoint();
    }

    @Bean
    public BindingsEndpoint.ResumeEndpoint resumeEndpoint(BindingsEndpoint bindingEndpoint) {
        return bindingEndpoint.getResumeEndpoint();
    }
}

