/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.micrometer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.micrometer.ApplicationMetricsProperties;
import org.springframework.cloud.stream.micrometer.MetersPublisherBinding;
import org.springframework.cloud.stream.micrometer.MetricsPublisherConfig;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;

class DefaultDestinationPublishingMeterRegistry
extends MeterRegistry
implements SmartLifecycle {
    private static final Log logger = LogFactory.getLog(DefaultDestinationPublishingMeterRegistry.class);
    private final MetricsPublisherConfig metricsPublisherConfig;
    private final Consumer<String> metricsConsumer;
    private final DecimalFormat format = new DecimalFormat("#.####");
    private final ApplicationMetricsProperties applicationProperties;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private ScheduledFuture<?> publisher;

    DefaultDestinationPublishingMeterRegistry(ApplicationMetricsProperties applicationProperties, MetersPublisherBinding publisherBinding, MetricsPublisherConfig metricsPublisherConfig, Clock clock) {
        super(clock);
        this.metricsPublisherConfig = metricsPublisherConfig;
        this.metricsConsumer = new MessageChannelPublisher(publisherBinding);
        this.applicationProperties = applicationProperties;
    }

    public void start() {
        this.start(Executors.defaultThreadFactory());
    }

    public void stop() {
        if (this.publisher != null) {
            this.publisher.cancel(false);
            this.publisher = null;
        }
    }

    public boolean isRunning() {
        return this.publisher != null;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        return new DefaultGauge(id, obj, f);
    }

    protected Counter newCounter(Meter.Id id) {
        return new CumulativeCounter(id);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new DefaultLongTaskTimer(id, this.clock);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected void publish() {
        ArrayList<Map<String, Object>> aggregatedMeters = new ArrayList<Map<String, Object>>();
        for (Meter meter : this.getMeters()) {
            if (meter instanceof Timer) {
                aggregatedMeters.add(this.timerMap((Timer)meter));
                continue;
            }
            if (!(meter instanceof DistributionSummary)) continue;
            aggregatedMeters.add(this.summaryMap((DistributionSummary)meter));
        }
        LinkedHashMap<String, Object> messageMap = new LinkedHashMap<String, Object>();
        messageMap.put("name", this.applicationProperties.getKey());
        messageMap.put("properties", this.applicationProperties.getExportProperties());
        messageMap.put("meter-snapshots", aggregatedMeters);
        try {
            String jsonString = this.objectMapper.writeValueAsString(messageMap);
            this.metricsConsumer.accept(jsonString);
        }
        catch (JsonProcessingException e) {
            logger.warn((Object)"Error producing JSON String representation metric data", (Throwable)e);
        }
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new CumulativeTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit());
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> valueFunction) {
        return new CumulativeFunctionCounter(id, obj, valueFunction);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new CumulativeDistributionSummary(id, this.clock, distributionStatisticConfig, scale);
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.metricsPublisherConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    private void start(ThreadFactory threadFactory) {
        if (this.publisher != null) {
            this.stop();
        }
        this.publisher = Executors.newSingleThreadScheduledExecutor(threadFactory).scheduleAtFixedRate(this::publish, this.metricsPublisherConfig.step().toMillis(), this.metricsPublisherConfig.step().toMillis(), TimeUnit.MILLISECONDS);
    }

    private Map<String, Object> summaryMap(DistributionSummary summary) {
        List<Field> fields = this.gatherSnapshotFields(summary.takeSnapshot(false));
        return this.toMeterMap(fields, summary.getId());
    }

    private Map<String, Object> timerMap(Timer timer) {
        List<Field> fields = this.gatherSnapshotFields(timer.takeSnapshot(false));
        return this.toMeterMap(fields, timer.getId());
    }

    private List<Field> gatherSnapshotFields(HistogramSnapshot snapshot) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("sum", snapshot.total(this.getBaseTimeUnit())));
        fields.add(new Field("count", snapshot.count()));
        fields.add(new Field("mean", snapshot.mean(this.getBaseTimeUnit())));
        fields.add(new Field("upper", snapshot.max(this.getBaseTimeUnit())));
        fields.add(new Field("total", snapshot.total(this.getBaseTimeUnit())));
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            fields.add(new Field(this.format.format(v.percentile()) + "_percentile", v.value(this.getBaseTimeUnit())));
        }
        return fields;
    }

    private Map<String, Object> toMeterMap(List<Field> fields, Meter.Id id) {
        LinkedHashMap<String, Object> meterMap = new LinkedHashMap<String, Object>();
        meterMap.put("id", id);
        meterMap.put("metrics", fields);
        return meterMap;
    }

    private static final class MessageChannelPublisher
    implements Consumer<String> {
        private final MetersPublisherBinding metersPublisherBinding;

        MessageChannelPublisher(MetersPublisherBinding metersPublisherBinding) {
            this.metersPublisherBinding = metersPublisherBinding;
        }

        @Override
        public void accept(String metricData) {
            logger.trace((Object)metricData);
            this.metersPublisherBinding.applicationMetrics().send((Message)new GenericMessage((Object)metricData));
        }
    }

    private class Field {
        final String name;
        final double value;

        private Field(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + DefaultDestinationPublishingMeterRegistry.this.format.format(this.value);
        }
    }
}

