/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.handler.annotation.support.PayloadArgumentResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

@Deprecated
class SmartPayloadArgumentResolver
extends PayloadArgumentResolver {
    private final MessageConverter messageConverter;

    SmartPayloadArgumentResolver(MessageConverter messageConverter) {
        super(messageConverter);
        this.messageConverter = messageConverter;
    }

    SmartPayloadArgumentResolver(MessageConverter messageConverter, Validator validator) {
        super(messageConverter, validator, true);
        this.messageConverter = messageConverter;
    }

    SmartPayloadArgumentResolver(MessageConverter messageConverter, Validator validator, boolean useDefaultResolution) {
        super(messageConverter, validator, useDefaultResolution);
        this.messageConverter = messageConverter;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return !Message.class.isAssignableFrom(parameter.getParameterType()) && !parameter.hasParameterAnnotation(Header.class) && !parameter.hasParameterAnnotation(Headers.class);
    }

    @Nullable
    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Payload ann = (Payload)parameter.getParameterAnnotation(Payload.class);
        if (ann != null && StringUtils.hasText((String)ann.expression())) {
            throw new IllegalStateException("@Payload SpEL expressions not supported by this resolver");
        }
        Object payload = message.getPayload();
        if (this.isEmptyPayload(payload)) {
            if (ann == null || ann.required()) {
                String paramName = this.getParameterName(parameter);
                BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(payload, paramName);
                bindingResult.addError(new ObjectError(paramName, "Payload value must not be empty"));
                throw new MethodArgumentNotValidException(message, parameter, (BindingResult)bindingResult);
            }
            return null;
        }
        Class targetClass = parameter.getParameterType();
        Class<?> payloadClass = payload.getClass();
        if (ClassUtils.isAssignable(payloadClass, (Class)targetClass)) {
            this.validate(message, parameter, payload);
            return payload;
        }
        if (this.messageConverter instanceof SmartMessageConverter) {
            SmartMessageConverter smartConverter = (SmartMessageConverter)this.messageConverter;
            payload = smartConverter.fromMessage(message, targetClass, (Object)parameter);
        } else {
            payload = this.messageConverter.fromMessage(message, targetClass);
        }
        if (payload == null) {
            throw new MessageConversionException(message, "Cannot convert from [" + payloadClass.getName() + "] to [" + targetClass.getName() + "] for " + message);
        }
        this.validate(message, parameter, payload);
        return payload;
    }

    private String getParameterName(MethodParameter param) {
        String paramName = param.getParameterName();
        return paramName != null ? paramName : "Arg " + param.getParameterIndex();
    }
}

