/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.util.Assert;

class FunctionCatalogWrapper {
    private final FunctionCatalog catalog;

    FunctionCatalogWrapper(FunctionCatalog catalog) {
        this.catalog = catalog;
    }

    <T> T lookup(Class<T> functionType, String name) {
        Object function = this.catalog.lookup(functionType, name);
        Assert.notNull((Object)function, (String)(functionType == null ? String.format("User provided Function '%s' cannot be located.", name) : String.format("User provided %s '%s' cannot be located.", functionType.getSimpleName(), name)));
        return (T)function;
    }

    <T> T lookup(String name) {
        return this.lookup(null, name);
    }

    <T> boolean contains(Class<T> functionType, String name) {
        return this.catalog.lookup(functionType, name) != null;
    }
}

