/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.function.FunctionCatalogWrapper;
import org.springframework.cloud.stream.function.IntegrationFlowFunctionSupport;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.cloud.stream.messaging.Processor;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.stream.function.definition"})
@EnableConfigurationProperties(value={StreamFunctionProperties.class})
public class FunctionConfiguration {
    @Autowired(required=false)
    private Source source;
    @Autowired(required=false)
    private Processor processor;
    @Autowired(required=false)
    private Sink sink;

    @Bean
    public IntegrationFlowFunctionSupport functionSupport(FunctionCatalogWrapper functionCatalog, FunctionInspector functionInspector, CompositeMessageConverterFactory messageConverterFactory, StreamFunctionProperties functionProperties, BindingServiceProperties bindingServiceProperties) {
        return new IntegrationFlowFunctionSupport(functionCatalog, functionInspector, messageConverterFactory, functionProperties, bindingServiceProperties);
    }

    @Bean
    public FunctionCatalogWrapper functionCatalogWrapper(FunctionCatalog catalog) {
        return new FunctionCatalogWrapper(catalog);
    }

    @ConditionalOnMissingBean
    @Bean
    public IntegrationFlow integrationFlowCreator(IntegrationFlowFunctionSupport functionSupport) {
        if (functionSupport.containsFunction(Consumer.class) && this.consumerBindingPresent()) {
            return functionSupport.integrationFlowForFunction(this.getInputChannel(), this.getOutputChannel()).get();
        }
        if (functionSupport.containsFunction(Function.class) && this.consumerBindingPresent()) {
            return functionSupport.integrationFlowForFunction(this.getInputChannel(), this.getOutputChannel()).get();
        }
        if (functionSupport.containsFunction(Supplier.class)) {
            return ((IntegrationFlowBuilder)functionSupport.integrationFlowFromNamedSupplier().channel(this.getOutputChannel())).get();
        }
        return null;
    }

    private boolean consumerBindingPresent() {
        return this.processor != null || this.sink != null;
    }

    private SubscribableChannel getInputChannel() {
        return this.processor != null ? this.processor.input() : this.sink.input();
    }

    private MessageChannel getOutputChannel() {
        return this.processor != null ? this.processor.output() : (this.source != null ? this.source.output() : new NullChannel());
    }
}

