/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.stream.config.BinderFactoryConfiguration;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.function.IntegrationFlowFunctionSupport;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.cloud.stream.messaging.Processor;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

@Configuration
@EnableConfigurationProperties(value={StreamFunctionProperties.class})
@Import(value={BinderFactoryConfiguration.class})
@AutoConfigureBefore(value={BindingServiceConfiguration.class})
public class FunctionConfiguration {
    @Bean
    public IntegrationFlowFunctionSupport functionSupport(FunctionCatalog functionCatalog, FunctionInspector functionInspector, CompositeMessageConverterFactory messageConverterFactory, StreamFunctionProperties functionProperties, BindingServiceProperties bindingServiceProperties) {
        ((SmartInitializingSingleton)functionCatalog).afterSingletonsInstantiated();
        return new IntegrationFlowFunctionSupport(functionCatalog, functionInspector, messageConverterFactory, functionProperties, bindingServiceProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public IntegrationFlow integrationFlowCreator(IntegrationFlowFunctionSupport functionSupport, @Nullable Source source, @Nullable Processor processor, @Nullable Sink sink) {
        if (functionSupport.containsFunction(Consumer.class) && this.consumerBindingPresent(processor, sink)) {
            return functionSupport.integrationFlowForFunction(this.getInputChannel(processor, sink), this.getOutputChannel(processor, source)).get();
        }
        if (functionSupport.containsFunction(Function.class) && this.consumerBindingPresent(processor, sink)) {
            return functionSupport.integrationFlowForFunction(this.getInputChannel(processor, sink), this.getOutputChannel(processor, source)).get();
        }
        if (functionSupport.containsFunction(Supplier.class)) {
            return ((IntegrationFlowBuilder)functionSupport.integrationFlowFromNamedSupplier().channel(this.getOutputChannel(processor, source))).get();
        }
        return null;
    }

    private boolean consumerBindingPresent(Processor processor, Sink sink) {
        return processor != null || sink != null;
    }

    private SubscribableChannel getInputChannel(Processor processor, Sink sink) {
        return processor != null ? processor.input() : sink.input();
    }

    private MessageChannel getOutputChannel(Processor processor, Source source) {
        return processor != null ? processor.output() : (source != null ? source.output() : new NullChannel());
    }
}

