/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.cascade.Cascade;
import cascading.flow.FlowDef;
import cascading.flow.FlowProps;
import cascading.flow.hadoop.HadoopFlow;
import cascading.flow.hadoop.HadoopFlowConnector;
import cascading.pipe.Pipe;
import cascading.property.AppProps;
import cascading.tap.Tap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.cascading.CascadeFactoryBean;
import org.springframework.data.hadoop.cascading.FlowFactoryBean;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;
import org.springframework.data.hadoop.util.ResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HadoopFlowFactoryBean
extends FlowFactoryBean<HadoopFlow>
implements BeanNameAware {
    private static final Log log = LogFactory.getLog(CascadeFactoryBean.class);
    private static String MARKER = HadoopFlowFactoryBean.class.getName() + "#SINGLE";
    private static boolean FILE_SEPARATOR_WARNING = true;
    private Configuration configuration;
    private Properties properties;
    private String beanName;
    private Integer maxConcurrentSteps;
    private Long jobPoolingInterval;
    private Map<String, Tap> sources;
    private Map<String, Tap> sinks;
    private Map<String, Tap> traps;
    private Collection<Pipe> tails;
    private FlowDef flowDef;
    private Class<?> jarClass;
    private Resource jar;
    private boolean addCascadingJars = true;

    @Override
    HadoopFlow createFlow() throws IOException {
        Tap tap;
        FlowDef def = FlowDef.flowDef();
        if (this.flowDef != null) {
            ((FlowDef)def.addSinks(this.flowDef.getSinksCopy()).addSources(this.flowDef.getSourcesCopy()).addTraps(this.flowDef.getTrapsCopy()).addTails(this.flowDef.getTailsArray()).setAssertionLevel(this.flowDef.getAssertionLevel()).setDebugLevel(this.flowDef.getDebugLevel()).addCheckpoints(this.flowDef.getCheckpointsCopy()).addTags(StringUtils.commaDelimitedListToStringArray((String)this.flowDef.getTags()))).setName(this.flowDef.getName());
        }
        LinkedHashSet heads = new LinkedHashSet();
        if (this.tails != null) {
            for (Pipe pipe : this.tails) {
                Collections.addAll(heads, pipe.getHeads());
            }
        }
        Pipe pipe = null;
        if (heads.size() == 1) {
            pipe = (Pipe)heads.iterator().next();
        }
        if (this.sources != null && this.sources.size() == 1 && (tap = this.sources.remove(MARKER)) != null) {
            this.sources.put(pipe.getName(), tap);
        }
        if (this.sinks != null && this.sinks.size() == 1 && (tap = this.sinks.remove(MARKER)) != null) {
            this.sinks.put(pipe.getName(), tap);
        }
        def.addSources(this.sources).addSinks(this.sinks).addTraps(this.traps);
        if (this.tails != null) {
            def.addTails(this.tails);
        }
        if (StringUtils.hasText((String)this.beanName)) {
            def.addTag(this.beanName);
            if (!StringUtils.hasText((String)def.getName())) {
                def.setName(this.beanName);
            }
        }
        Configuration cfg = ConfigurationUtils.createFrom((Configuration)this.configuration, (Properties)this.properties);
        Properties props = ConfigurationUtils.asProperties((Configuration)cfg);
        if (this.jar != null) {
            AppProps.setApplicationJarPath((Map)props, (String)ResourceUtils.decode((String)this.jar.getURI().toString()));
        } else if (this.jarClass != null) {
            AppProps.setApplicationJarClass((Map)props, this.jarClass);
        }
        if (this.addCascadingJars) {
            if (FILE_SEPARATOR_WARNING && !":".equals(System.getProperty("path.separator"))) {
                log.warn((Object)"System path separator is not ':' - this will likely cause invalid classpath entries within the DistributedCache. See the docs and HADOOP-9123 for more information.");
                FILE_SEPARATOR_WARNING = false;
            }
            ClassLoader cascadingCL = Cascade.class.getClassLoader();
            Resource cascadingCore = ResourceUtils.findContainingJar(Cascade.class);
            Resource cascadingHadoop = ResourceUtils.findContainingJar((ClassLoader)cascadingCL, (String)"cascading/flow/hadoop/HadoopFlow.class");
            Resource jgrapht = ResourceUtils.findContainingJar((ClassLoader)cascadingCL, (String)"org/jgrapht/Graph.class");
            Resource riffle = ResourceUtils.findContainingJar((ClassLoader)cascadingCL, (String)"riffle/process/Process.class");
            Resource janino = ResourceUtils.findContainingJar((ClassLoader)cascadingCL, (String)"org/codehaus/janino/Java.class");
            Resource commonsCompiler = ResourceUtils.findContainingJar((ClassLoader)cascadingCL, (String)"org/codehaus/commons/compiler/CompileException.class");
            Assert.notNull((Object)cascadingCore, (String)"Cannot find cascading-core.jar");
            Assert.notNull((Object)cascadingHadoop, (String)"Cannot find cascading-hadoop.jar");
            Assert.notNull((Object)jgrapht, (String)"Cannot find jgraphts-jdk.jar");
            Assert.notNull((Object)riffle, (String)"Cannot find riffle.jar");
            Assert.notNull((Object)janino, (String)"Cannot find janino.jar");
            Assert.notNull((Object)commonsCompiler, (String)"Cannot find commons-compiler.jar");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Auto-detecting Cascading Libs [" + Arrays.toString(new Resource[]{cascadingCore, cascadingHadoop, jgrapht, riffle, janino, commonsCompiler}) + "]"));
            }
            ConfigurationUtils.addLibs((Configuration)cfg, (Resource[])new Resource[]{cascadingCore, cascadingHadoop, jgrapht, riffle, janino, commonsCompiler});
            props = ConfigurationUtils.asProperties((Configuration)cfg);
        }
        if (this.jobPoolingInterval != null) {
            FlowProps.setJobPollingInterval((Map)props, (long)this.jobPoolingInterval);
        }
        if (this.maxConcurrentSteps != null) {
            FlowProps.setMaxConcurrentSteps((Map)props, (int)this.maxConcurrentSteps);
        }
        HadoopFlow flow = (HadoopFlow)new HadoopFlowConnector((Map)props).connect(def);
        return flow;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setMaxConcurrentSteps(Integer maxConcurrentSteps) {
        this.maxConcurrentSteps = maxConcurrentSteps;
    }

    public void setJobPoolingInterval(Long jobPoolingInterval) {
        this.jobPoolingInterval = jobPoolingInterval;
    }

    public void setSources(Map<String, Tap> sources) {
        this.sources = sources;
    }

    public void setSource(Tap source) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(MARKER, source);
        this.sources = sources;
    }

    public void setSinks(Map<String, Tap> sinks) {
        this.sinks = sinks;
    }

    public void setSink(Tap sink) {
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(MARKER, sink);
        this.sinks = sinks;
    }

    public void setTraps(Map<String, Tap> traps) {
        this.traps = traps;
    }

    public void setTails(Collection<Pipe> tails) {
        this.tails = tails;
    }

    public void setTail(Pipe tail) {
        this.tails = new ArrayList<Pipe>(1);
        this.tails.add(tail);
    }

    public void setDefinition(FlowDef flowDef) {
        this.flowDef = flowDef;
    }

    public void setJarByClass(Class<?> jarClass) {
        this.jarClass = jarClass;
    }

    public void setJar(Resource jar) {
        this.jar = jar;
    }

    public void setAddCascadingJars(boolean addCascadingJars) {
        this.addCascadingJars = addCascadingJars;
    }
}

